/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Push.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PushSettings
implements PersistentStateComponent<State> {
    private State myState = new State();

    @Override
    @Nullable
    public State getState() {
        return this.myState;
    }

    @Override
    public void loadState(State state) {
        this.myState = state;
    }

    @NotNull
    public Set<String> getExcludedRepoRoots() {
        return this.myState.EXCLUDED_ROOTS;
    }

    public void saveExcludedRepoRoots(@NotNull Set<String> roots) {
        this.myState.EXCLUDED_ROOTS = roots;
    }

    public boolean containsForcePushTarget(final @NotNull String remote, final @NotNull String branch) {
        return ContainerUtil.exists(this.myState.FORCE_PUSH_TARGETS, (Condition)new Condition<ForcePushTargetInfo>(){

            public boolean value(ForcePushTargetInfo info) {
                return info.targetRemoteName.equals(remote) && info.targetBranchName.equals(branch);
            }
        });
    }

    public void addForcePushTarget(@NotNull String targetRemote, @NotNull String targetBranch) {
        List<ForcePushTargetInfo> targets = this.myState.FORCE_PUSH_TARGETS;
        if (!this.containsForcePushTarget(targetRemote, targetBranch)) {
            targets.add(new ForcePushTargetInfo(targetRemote, targetBranch));
            this.myState.FORCE_PUSH_TARGETS = targets;
        }
    }

    @Tag(value="force-push-target")
    private static class ForcePushTargetInfo {
        @Attribute(value="remote-path")
        public String targetRemoteName;
        @Attribute(value="branch")
        public String targetBranchName;

        ForcePushTargetInfo() {
            this("", "");
        }

        ForcePushTargetInfo(@NotNull String targetRemote, @NotNull String targetBranch) {
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }
    }

    public static class State {
        @Tag(value="excluded-roots")
        @AbstractCollection(surroundWithTag=false, elementTag="path")
        public Set<String> EXCLUDED_ROOTS = ContainerUtil.newHashSet();
        @AbstractCollection(surroundWithTag=false)
        @Tag(value="force-push-targets")
        public List<ForcePushTargetInfo> FORCE_PUSH_TARGETS = ContainerUtil.newArrayList();
    }
}

