/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolWrapper<T extends InspectionProfileEntry, E extends InspectionEP> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolWrapper");
    protected T myTool;
    protected final E myEP;

    protected InspectionToolWrapper(@NotNull E ep) {
        this(null, ep);
    }

    protected InspectionToolWrapper(@NotNull T tool) {
        this(tool, null);
    }

    protected InspectionToolWrapper(@Nullable T tool, @Nullable E ep) {
        assert (tool != null || ep != null) : "must not be both null";
        this.myEP = ep;
        this.myTool = tool;
    }

    protected InspectionToolWrapper(@NotNull InspectionToolWrapper<T, E> other) {
        this.myEP = other.myEP;
        this.myTool = other.myTool != null ? (this.myEP != null ? ((InspectionEP)this.myEP).instantiateTool() : (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool(other.myTool.getClass())) : null;
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        this.projectOpened(context.getProject());
    }

    @NotNull
    public abstract InspectionToolWrapper<T, E> createCopy();

    @NotNull
    public T getTool() {
        Object tool = this.myTool;
        if (tool == null) {
            tool = ((InspectionEP)this.myEP).instantiateTool();
            this.myTool = tool;
            if (!((InspectionProfileEntry)tool).getShortName().equals(((InspectionEP)this.myEP).getShortName())) {
                LOG.error("Short name not matched for " + tool.getClass() + ": getShortName() = " + ((InspectionProfileEntry)tool).getShortName() + "; ep.shortName = " + ((InspectionEP)this.myEP).getShortName());
            }
        }
        return tool;
    }

    public boolean isInitialized() {
        return this.myTool != null;
    }

    @Nullable
    public String getLanguage() {
        return this.myEP == null ? null : ((InspectionEP)this.myEP).language;
    }

    public boolean applyToDialects() {
        return this.myEP != null && ((InspectionEP)this.myEP).applyToDialects;
    }

    public boolean isApplicable(@NotNull Language language) {
        String langId = this.getLanguage();
        return langId == null || language.getID().equals(langId) || this.applyToDialects() && language.isKindOf(langId);
    }

    public boolean isCleanupTool() {
        return this.myEP != null ? ((InspectionEP)this.myEP).cleanupTool : this.getTool() instanceof CleanupLocalInspectionTool;
    }

    @NotNull
    public String getShortName() {
        return this.myEP != null ? ((InspectionEP)this.myEP).getShortName() : ((InspectionProfileEntry)this.getTool()).getShortName();
    }

    public String getID() {
        return this.getShortName();
    }

    @NotNull
    public String getDisplayName() {
        if (this.myEP == null) {
            return ((InspectionProfileEntry)this.getTool()).getDisplayName();
        }
        String name = ((InspectionEP)this.myEP).getDisplayName();
        return name == null ? ((InspectionProfileEntry)this.getTool()).getDisplayName() : name;
    }

    @NotNull
    public String getGroupDisplayName() {
        if (this.myEP == null) {
            return ((InspectionProfileEntry)this.getTool()).getGroupDisplayName();
        }
        String groupDisplayName = ((InspectionEP)this.myEP).getGroupDisplayName();
        return groupDisplayName == null ? ((InspectionProfileEntry)this.getTool()).getGroupDisplayName() : groupDisplayName;
    }

    public boolean isEnabledByDefault() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).isEnabledByDefault() : ((InspectionEP)this.myEP).enabledByDefault;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).getDefaultLevel() : ((InspectionEP)this.myEP).getDefaultLevel();
    }

    @NotNull
    public String[] getGroupPath() {
        if (this.myEP == null) {
            return ((InspectionProfileEntry)this.getTool()).getGroupPath();
        }
        String[] path2 = ((InspectionEP)this.myEP).getGroupPath();
        return path2 == null ? ((InspectionProfileEntry)this.getTool()).getGroupPath() : path2;
    }

    public void projectOpened(@NotNull Project project) {
        if (this.myEP == null) {
            ((InspectionProfileEntry)this.getTool()).projectOpened(project);
        }
    }

    public void projectClosed(@NotNull Project project) {
        if (this.myEP == null) {
            ((InspectionProfileEntry)this.getTool()).projectClosed(project);
        }
    }

    public String getStaticDescription() {
        return this.myEP == null || ((InspectionEP)this.myEP).hasStaticDescription ? ((InspectionProfileEntry)this.getTool()).getStaticDescription() : null;
    }

    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            URL descriptionUrl = this.getDescriptionUrl();
            if (descriptionUrl == null) {
                return null;
            }
            return ResourceUtil.loadText((URL)descriptionUrl);
        }
        catch (IOException iOException) {
            return ((InspectionProfileEntry)this.getTool()).loadDescription();
        }
    }

    protected URL getDescriptionUrl() {
        Application app = ApplicationManager.getApplication();
        if (this.myEP == null || app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return this.superGetDescriptionUrl();
        }
        String fileName = this.getDescriptionFileName();
        return this.myEP.getLoaderForClass().getResource("/inspectionDescriptions/" + fileName);
    }

    @Nullable
    protected URL superGetDescriptionUrl() {
        String fileName = this.getDescriptionFileName();
        return ResourceUtil.getResource(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
    }

    @NotNull
    public String getDescriptionFileName() {
        return this.getShortName() + ".html";
    }

    @NotNull
    public final String getFolderName() {
        return this.getShortName();
    }

    @NotNull
    public Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        return this.getTool().getClass();
    }

    public String getMainToolId() {
        return ((InspectionProfileEntry)this.getTool()).getMainToolId();
    }

    public E getExtension() {
        return this.myEP;
    }

    public String toString() {
        return this.getShortName();
    }

    public void cleanup(@NotNull Project project) {
        T tool = this.myTool;
        if (tool != null) {
            ((InspectionProfileEntry)tool).cleanup(project);
        }
    }

    @NotNull
    public abstract JobDescriptor[] getJobDescriptors(@NotNull GlobalInspectionContext var1);
}

