/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSuppressableInspectionTool
extends LocalInspectionTool
implements BatchSuppressableTool {
    @NonNls
    static final String ALL = "ALL";

    @NotNull
    public static SuppressQuickFix[] getSuppressFixes(@NotNull String toolId) {
        return XmlSuppressableInspectionTool.getSuppressFixes(toolId, new DefaultXmlSuppressionProvider());
    }

    @NotNull
    public static SuppressQuickFix[] getSuppressFixes(@NotNull String toolId, @NotNull XmlSuppressionProvider provider) {
        return new SuppressQuickFix[]{new SuppressTagStatic(toolId, provider), new SuppressForFile(toolId, provider), new SuppressAllForFile(provider)};
    }

    public static class SuppressAllForFile
    extends SuppressForFile {
        public SuppressAllForFile(XmlSuppressionProvider provider) {
            super(XmlSuppressableInspectionTool.ALL, provider);
        }

        public SuppressAllForFile() {
            super(XmlSuppressableInspectionTool.ALL);
        }

        @Override
        @NotNull
        public String getName() {
            return InspectionsBundle.message("xml.suppressable.all.for.file.title", new Object[0]);
        }
    }

    public static class SuppressForFile
    extends XmlSuppressFix {
        public SuppressForFile(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressForFile(String id) {
            super(id);
        }

        @Override
        @NotNull
        public String getName() {
            return InspectionsBundle.message("xml.suppressable.for.file.title", new Object[0]);
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement container = this.getContainer(element);
            if (container instanceof XmlFile) {
                this.myProvider.suppressForFile(element, this.myId);
            }
        }

        @Override
        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return context == null || !context.isValid() ? null : context.getContainingFile();
        }
    }

    public static class SuppressTagStatic
    extends XmlSuppressFix {
        public SuppressTagStatic(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressTagStatic(String id) {
            super(id);
        }

        @Override
        @NotNull
        public String getName() {
            return InspectionsBundle.message("xml.suppressable.for.tag.title", new Object[0]);
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (PsiTreeUtil.getParentOfType(element, XmlTag.class) == null) {
                return;
            }
            this.myProvider.suppressForTag(element, this.myId);
        }

        @Override
        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return PsiTreeUtil.getParentOfType(context, XmlTag.class);
        }
    }

    public static abstract class XmlSuppressFix
    implements InjectionAwareSuppressQuickFix,
    ContainerBasedSuppressQuickFix {
        protected final String myId;
        protected final XmlSuppressionProvider myProvider;
        private ThreeState myShouldBeAppliedToInjectionHost = ThreeState.UNSURE;

        protected XmlSuppressFix(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            this.myId = inspectionId;
            this.myProvider = suppressionProvider;
        }

        protected XmlSuppressFix(String id) {
            this(id, new DefaultXmlSuppressionProvider());
        }

        @Override
        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            return context.isValid() && this.getContainer(context) != null;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return null;
        }

        @Override
        @NotNull
        public ThreeState isShouldBeAppliedToInjectionHost() {
            return this.myShouldBeAppliedToInjectionHost;
        }

        @Override
        public void setShouldBeAppliedToInjectionHost(@NotNull ThreeState shouldBeAppliedToInjectionHost) {
            this.myShouldBeAppliedToInjectionHost = shouldBeAppliedToInjectionHost;
        }
    }
}

