/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.BatchSuppressManager;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SuppressManager
implements BatchSuppressManager,
InspectionSuppressor {
    public static SuppressManager getInstance() {
        return ServiceManager.getService(SuppressManager.class);
    }

    public static boolean isSuppressedInspectionName(PsiLiteralExpression expression) {
        PsiAnnotation annotation = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAnnotation.class, true, PsiCodeBlock.class, PsiField.class);
        return annotation != null && "java.lang.SuppressWarnings".equals(annotation.getQualifiedName());
    }

    @Override
    @NotNull
    public SuppressQuickFix[] createBatchSuppressActions(@NotNull HighlightDisplayKey key) {
        return BatchSuppressManager.SERVICE.getInstance().createBatchSuppressActions(key);
    }

    @NotNull
    public abstract SuppressIntentionAction[] createSuppressActions(@NotNull HighlightDisplayKey var1);
}

