/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ActionClassHolder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class IntentionWrapper
implements LocalQuickFix,
IntentionAction,
ActionClassHolder {
    private final IntentionAction myAction;
    private final PsiFile myFile;

    public IntentionWrapper(@NotNull IntentionAction action, @NotNull PsiFile file) {
        this.myAction = action;
        this.myFile = file;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myAction.getText();
    }

    @Override
    @NotNull
    public String getText() {
        return this.myAction.getText();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.myAction.getFamilyName();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myAction.isAvailable(project, editor, file);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myAction.invoke(project, editor, file);
    }

    @Override
    public boolean startInWriteAction() {
        return this.myAction.startInWriteAction();
    }

    @NotNull
    public IntentionAction getAction() {
        return this.myAction;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile != null) {
            FileEditor editor = FileEditorManager.getInstance(project).getSelectedEditor(virtualFile);
            this.myAction.invoke(project, editor instanceof TextEditor ? ((TextEditor)editor).getEditor() : null, this.myFile);
        }
    }

    @Override
    @NotNull
    public Class getActionClass() {
        return this.getAction().getClass();
    }
}

