/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.util.ClassConditionKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AutoCompletionPolicy {
    NEVER_AUTOCOMPLETE,
    SETTINGS_DEPENDENT,
    GIVE_CHANCE_TO_OVERWRITE,
    ALWAYS_AUTOCOMPLETE;


    @NotNull
    public LookupElement applyPolicy(@NotNull LookupElement element) {
        return new PolicyDecorator(element, this);
    }

    @Deprecated
    @Nullable
    public static AutoCompletionPolicy getPolicy(LookupElement element) {
        return element.getAutoCompletionPolicy();
    }

    private static class PolicyDecorator
    extends LookupElementDecorator<LookupElement> {
        public static final ClassConditionKey<PolicyDecorator> CLASS_CONDITION_KEY = ClassConditionKey.create(PolicyDecorator.class);
        private final AutoCompletionPolicy myPolicy;

        public PolicyDecorator(LookupElement element, AutoCompletionPolicy policy) {
            super(element);
            this.myPolicy = policy;
        }

        @Override
        public AutoCompletionPolicy getAutoCompletionPolicy() {
            return this.myPolicy;
        }
    }
}

