/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class PriorityLocalQuickFixWrapper
implements LocalQuickFix {
    private final LocalQuickFix fix;

    private PriorityLocalQuickFixWrapper(@NotNull LocalQuickFix fix) {
        this.fix = fix;
    }

    @Override
    @NotNull
    public String getName() {
        return this.fix.getName();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.fix.getFamilyName();
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        this.fix.applyFix(project, descriptor);
    }

    @NotNull
    public static LocalQuickFix highPriority(@NotNull LocalQuickFix fix) {
        return new HighPriorityLocalQuickFixWrapper(fix);
    }

    @NotNull
    public static LocalQuickFix normalPriority(@NotNull LocalQuickFix fix) {
        return new NormalPriorityLocalQuickFixWrapper(fix);
    }

    @NotNull
    public static LocalQuickFix lowPriority(@NotNull LocalQuickFix fix) {
        return new LowPriorityLocalQuickFixWrapper(fix);
    }

    private static class LowPriorityLocalQuickFixWrapper
    extends PriorityLocalQuickFixWrapper
    implements LowPriorityAction {
        protected LowPriorityLocalQuickFixWrapper(@NotNull LocalQuickFix fix) {
            super(fix);
        }
    }

    private static class NormalPriorityLocalQuickFixWrapper
    extends PriorityLocalQuickFixWrapper {
        protected NormalPriorityLocalQuickFixWrapper(@NotNull LocalQuickFix fix) {
            super(fix);
        }
    }

    private static class HighPriorityLocalQuickFixWrapper
    extends PriorityLocalQuickFixWrapper
    implements HighPriorityAction {
        protected HighPriorityLocalQuickFixWrapper(@NotNull LocalQuickFix fix) {
            super(fix);
        }
    }
}

