/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.analysis.AnalysisScope");
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static final int UNCOMMITTED_FILES = 10;
    @NotNull
    private final Project myProject;
    protected List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    private SearchScope myScope;
    private boolean mySearchInLibraries;
    private GlobalSearchScope myFilter;
    @Type
    protected int myType;
    private final Set<VirtualFile> myVFiles;
    protected Set<VirtualFile> myFilesSet;
    protected boolean myIncludeTestSource = true;

    public AnalysisScope(@NotNull Project project) {
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module module) {
        this.myProject = module.getProject();
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module[] modules) {
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = modules[0].getProject();
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory) {
        this.myProject = psiDirectory.getProject();
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiFile psiFile) {
        this.myProject = psiFile.getProject();
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull SearchScope scope, @NotNull Project project) {
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && ((GlobalSearchScope)scope).isSearchInLibraries();
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Project project, @NotNull Collection<VirtualFile> virtualFiles) {
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myVFiles = new HashSet<VirtualFile>(virtualFiles);
        this.myType = 9;
    }

    public void setScope(SearchScope scope) {
        this.myScope = scope;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        this.myIncludeTestSource = includeTestSource;
    }

    @NotNull
    protected PsiElementVisitor createFileSearcher() {
        final FileIndex fileIndex = this.getFileIndex();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(AnalysisScopeBundle.message("scanning.scope.progress.title", new Object[0]));
        }
        return new PsiElementVisitor(){

            @Override
            public void visitFile(@NotNull PsiFile file) {
                if (AnalysisScope.this.mySearchInLibraries || !(file instanceof PsiCompiledElement)) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    if (AnalysisScope.this.isFiltered(virtualFile, fileIndex)) {
                        return;
                    }
                    if (!AnalysisScope.shouldHighlightFile(file)) {
                        return;
                    }
                    AnalysisScope.this.myFilesSet.add(virtualFile);
                }
            }
        };
    }

    private boolean isFiltered(VirtualFile virtualFile, FileIndex fileIndex) {
        if (this.myFilter != null && !this.myFilter.contains(virtualFile)) {
            return true;
        }
        return !this.myIncludeTestSource && fileIndex.isInTestSourceContent(virtualFile);
    }

    @NotNull
    private FileIndex getFileIndex() {
        FileIndex fileIndex = this.myModule != null ? ModuleRootManager.getInstance(this.myModule).getFileIndex() : ProjectRootManager.getInstance(this.myProject).getFileIndex();
        return fileIndex;
    }

    private static String displayProjectRelativePath(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        return ProjectUtilCore.displayUrlRelativeToProject(virtualFile, virtualFile.getPresentableUrl(), project, false, false);
    }

    public boolean contains(@NotNull PsiElement psiElement) {
        VirtualFile file = psiElement.getContainingFile().getVirtualFile();
        return file != null && this.contains(file);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (this.myFilesSet == null) {
            if (this.myType == 8) {
                if (this.myScope instanceof GlobalSearchScope) {
                    return ((GlobalSearchScope)this.myScope).contains(file);
                }
                if (this.myScope instanceof LocalSearchScope) {
                    return ((LocalSearchScope)this.myScope).isInScope(file);
                }
            }
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index.isInContent(file) && !this.isFiltered(file, index);
            }
            this.initFilesSet();
        }
        return this.myFilesSet.contains(file);
    }

    protected void initFilesSet() {
        if (this.myType == 3) {
            this.myFilesSet = new HashSet<VirtualFile>(1);
            this.myFilesSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
        } else if (this.myType == 2 || this.myType == 1 || this.myType == 7 || this.myType == 4 || this.myType == 8) {
            this.myFilesSet = new HashSet<VirtualFile>();
            this.accept(this.createFileSearcher(), false);
        } else if (this.myType == 9) {
            this.myFilesSet = new HashSet<VirtualFile>();
            final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            Iterator<VirtualFile> iterator = this.myVFiles.iterator();
            while (iterator.hasNext()) {
                VirtualFile vFile = iterator.next();
                VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    @Override
                    @NotNull
                    public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                        boolean ignored = fileIndex.isExcluded(file);
                        if (!ignored && !file.isDirectory()) {
                            AnalysisScope.this.myFilesSet.add(file);
                        }
                        return ignored ? SKIP_CHILDREN : CONTINUE;
                    }
                });
                if (!vFile.isDirectory()) continue;
                iterator.remove();
            }
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        this.accept(visitor, true);
    }

    private void accept(final @NotNull PsiElementVisitor visitor, final boolean clearResolveCache) {
        final boolean needReadAction = !ApplicationManager.getApplication().isReadAccessAllowed();
        final PsiManager psiManager = PsiManager.getInstance(this.myProject);
        final FileIndex fileIndex = this.getFileIndex();
        this.accept(new Processor<VirtualFile>(){

            public boolean process(VirtualFile file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (ProjectCoreUtil.isProjectOrWorkspaceFile(file)) {
                    return true;
                }
                if (fileIndex.isInContent(file) && !AnalysisScope.this.isFiltered(file, fileIndex) && !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, AnalysisScope.this.myProject)) {
                    return AnalysisScope.processFile(file, visitor, psiManager, needReadAction, clearResolveCache);
                }
                return true;
            }
        });
    }

    public boolean accept(@NotNull Processor<VirtualFile> processor) {
        List<Module> modules;
        if (this.myType == 9) {
            if (this.myFilesSet == null) {
                this.initFilesSet();
            }
            ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            for (VirtualFile file : this.myFilesSet) {
                if (this.isFiltered(file, index) || processor.process((Object)file)) continue;
                return false;
            }
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        if (this.myScope instanceof GlobalSearchScope) {
            ContentIterator contentIterator = this.createScopeIterator(processor, projectFileIndex, this.myScope);
            if (!projectFileIndex.iterateContent(contentIterator)) {
                return false;
            }
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    if (VfsUtilCore.iterateChildrenRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.myScope instanceof LocalSearchScope) {
            PsiElement[] psiElements = ((LocalSearchScope)this.myScope).getScope();
            THashSet files = new THashSet();
            for (final PsiElement element : psiElements) {
                VirtualFile file = ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

                    public VirtualFile compute() {
                        return PsiUtilCore.getVirtualFile(element);
                    }
                });
                if (file == null || !files.add(file) || processor.process((Object)file)) continue;
                return false;
            }
            return true;
        }
        List<Module> list = modules = this.myModule != null ? Collections.singletonList(this.myModule) : this.myModules;
        if (modules != null) {
            for (Module module : modules) {
                ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
                if (moduleFileIndex.iterateContent(this.createScopeIterator(processor, moduleFileIndex, null))) continue;
                return false;
            }
            return true;
        }
        if (this.myElement instanceof PsiDirectory) {
            return this.accept((PsiDirectory)this.myElement, processor);
        }
        if (this.myElement != null) {
            VirtualFile file = ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    return PsiUtilCore.getVirtualFile(AnalysisScope.this.myElement);
                }
            });
            return file == null || processor.process((Object)file);
        }
        return projectFileIndex.iterateContent(this.createScopeIterator(processor, projectFileIndex, null));
    }

    @NotNull
    private ContentIterator createScopeIterator(final @NotNull Processor<VirtualFile> processor, final @NotNull FileIndex projectFileIndex, final @Nullable SearchScope searchScope) {
        return new ContentIterator(){

            @Override
            public boolean processFile(final @NotNull VirtualFile fileOrDir) {
                boolean isInScope = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                    public Boolean compute() {
                        if (AnalysisScope.this.isFiltered(fileOrDir, projectFileIndex)) {
                            return false;
                        }
                        if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, AnalysisScope.this.myProject)) {
                            return false;
                        }
                        return searchScope == null || ((GlobalSearchScope)searchScope).contains(fileOrDir);
                    }
                });
                return !isInScope || processor.process((Object)fileOrDir);
            }
        };
    }

    private static boolean processFile(final @NotNull VirtualFile vFile, final @NotNull PsiElementVisitor visitor, final @NotNull PsiManager psiManager, boolean needReadAction, final boolean clearResolveCache) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AnalysisScope.doProcessFile(visitor, psiManager, vFile, clearResolveCache);
            }
        };
        if (needReadAction && !ApplicationManager.getApplication().isDispatchThread()) {
            AnalysisScope.commitAndRunInSmartMode(runnable, psiManager.getProject());
        } else {
            runnable.run();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    private static void commitAndRunInSmartMode(final Runnable runnable, Project project) {
        DumbService dumbService;
        boolean passed;
        do {
            dumbService = DumbService.getInstance(project);
            dumbService.waitForSmartMode();
        } while (!(passed = PsiDocumentManager.getInstance(project).commitAndRunReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                if (dumbService.isDumb()) {
                    return false;
                }
                runnable.run();
                return true;
            }
        }).booleanValue()));
    }

    protected static boolean shouldHighlightFile(@NotNull PsiFile file) {
        return ProblemHighlightFilter.shouldProcessFileInBatch(file);
    }

    public boolean containsModule(@NotNull Module module) {
        switch (this.myType) {
            case 1: {
                return true;
            }
            case 4: {
                return this.myModule == module;
            }
            case 7: {
                return this.myModules.contains(module);
            }
        }
        return false;
    }

    private static void doProcessFile(@NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, @NotNull VirtualFile vFile, boolean clearResolveCache) {
        if (!vFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(vFile);
        if (psiFile == null || !AnalysisScope.shouldHighlightFile(psiFile)) {
            return;
        }
        psiFile.accept(visitor);
        if (clearResolveCache) {
            psiManager.dropResolveCaches();
            InjectedLanguageManager.getInstance(psiManager.getProject()).dropFileCaches(psiFile);
        }
    }

    protected boolean accept(@NotNull PsiDirectory dir, final @NotNull Processor<VirtualFile> processor) {
        final Project project = dir.getProject();
        final ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
        final boolean processGeneratedFiles = GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(dir.getVirtualFile(), project);
        return VfsUtilCore.iterateChildrenRecursively(dir.getVirtualFile(), VirtualFileFilter.ALL, new ContentIterator(){

            @Override
            public boolean processFile(@NotNull VirtualFile fileOrDir) {
                if (AnalysisScope.this.isFiltered(fileOrDir, index)) {
                    return true;
                }
                if (!processGeneratedFiles && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, project)) {
                    return true;
                }
                if (!fileOrDir.isDirectory()) {
                    return processor.process((Object)fileOrDir);
                }
                return true;
            }
        });
    }

    public boolean isValid() {
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        if (this.myModule != null) {
            return !this.myModule.isDisposed();
        }
        if (this.myElement != null) {
            return this.myElement.isValid();
        }
        return this.myType == 9 || this.myType == 8 || this.myType == 1;
    }

    @Type
    public int getScopeType() {
        return this.myType;
    }

    @NotNull
    public String getDisplayName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, (Function)new Function<Module, String>(){

                    public String fun(@NotNull Module module) {
                        return AnalysisScope.pathToName(module.getModuleFilePath());
                    }
                }, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                return AnalysisScopeBundle.message("scope.file", AnalysisScope.getPresentableUrl((PsiFileSystemItem)this.myElement));
            }
            case 2: {
                return AnalysisScopeBundle.message("scope.directory", AnalysisScope.getPresentableUrl((PsiFileSystemItem)this.myElement));
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.virtual.files", new Object[0]);
            }
        }
        return "";
    }

    @NotNull
    private static String getPresentableUrl(@NotNull PsiFileSystemItem element) {
        VirtualFile virtualFile = element.getVirtualFile();
        assert (virtualFile != null) : element;
        return virtualFile.getPresentableUrl();
    }

    @NotNull
    public String getShortenName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", this.myModule.getName());
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, (Function)new Function<Module, String>(){

                    @NotNull
                    public String fun(@NotNull Module module) {
                        return module.getName();
                    }
                }, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                String relativePath = this.getRelativePath();
                return relativePath != null ? AnalysisScopeBundle.message("scope.file", relativePath) : "Current File";
            }
            case 2: {
                String relativeDirPath = this.getRelativePath();
                return relativeDirPath != null ? AnalysisScopeBundle.message("scope.directory", relativeDirPath) : "Current Directory";
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.selected.files", new Object[0]);
            }
        }
        return "";
    }

    @Nullable
    private String getRelativePath() {
        String relativePath = AnalysisScope.displayProjectRelativePath(((PsiFileSystemItem)this.myElement).getVirtualFile(), this.myElement.getProject());
        if (relativePath.length() > 100) {
            return null;
        }
        return relativePath;
    }

    @NotNull
    private static String pathToName(@NotNull String path2) {
        File file = new File(path2);
        return FileUtil.getNameWithoutExtension((File)file);
    }

    public int getFileCount() {
        ProgressIndicator indicator;
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText("");
            indicator.setText2("");
        }
        return this.myFilesSet.size();
    }

    @Deprecated
    public boolean checkScopeWritable(@NotNull Project project) {
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        return !FileModificationService.getInstance().prepareVirtualFilesForWrite(project, this.myFilesSet);
    }

    public void invalidate() {
        if (this.myType == 9) {
            Iterator<VirtualFile> i = this.myVFiles.iterator();
            while (i.hasNext()) {
                VirtualFile virtualFile = i.next();
                if (virtualFile != null && virtualFile.isValid()) continue;
                i.remove();
            }
        } else {
            this.myFilesSet = null;
        }
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file;
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index.isInSourceContent(directory)) {
                    return isTest ? index.isInTestSourceContent(directory) : !index.isInTestSourceContent(directory);
                }
            } else if (this.myElement instanceof PsiFile && (file = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest ? index.isInTestSourceContent(file) : !index.isInTestSourceContent(file);
            }
        }
        return true;
    }

    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3 || this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        return AnalysisScope.collectScopes(defaultProject, modules);
    }

    @NotNull
    protected static AnalysisScope collectScopes(@NotNull Project defaultProject, @NotNull HashSet<Module> modules) {
        if (modules.isEmpty()) {
            return new AnalysisScope(defaultProject);
        }
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        HashSet<Module> modulesToAnalyze = new HashSet<Module>();
        for (Module module : modules) {
            modulesToAnalyze.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
        }
        return new AnalysisScope(modulesToAnalyze.toArray(new Module[modulesToAnalyze.size()]));
    }

    @NotNull
    private static Set<Module> getExportBackwardDependencies(@NotNull Module fromModule, @NotNull Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported() || fromModule != ((ModuleOrderEntry)orderEntry).getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        return result;
    }

    @NotNull
    private static Set<Module> getDirectBackwardDependencies(@NotNull Module module, @NotNull Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find((Object[])ModuleRootManager.getInstance(dependency).getDependencies(), (Object)module) <= -1) continue;
            result.add(dependency);
        }
        return result;
    }

    @NotNull
    protected static HashSet<Module> getAllInterestingModules(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        return modules;
    }

    @NotNull
    public SearchScope toSearchScope() {
        switch (this.myType) {
            case 8: {
                return this.myScope;
            }
            case 2: {
                return GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myElement, true);
            }
            case 3: {
                return new LocalSearchScope(this.myElement);
            }
            case 6: {
                return LocalSearchScope.EMPTY;
            }
            case 4: {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope(this.myModule);
                return this.myIncludeTestSource ? moduleScope : GlobalSearchScope.notScope(GlobalSearchScopesCore.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
            }
            case 7: {
                SearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
                for (Module module : this.myModules) {
                    scope = ((SearchScope)scope).union(GlobalSearchScope.moduleScope(module));
                }
                return scope;
            }
            case 1: {
                return this.myIncludeTestSource ? GlobalSearchScope.projectScope(this.myProject) : GlobalSearchScopesCore.projectProductionScope(this.myProject);
            }
            case 9: {
                return new GlobalSearchScope(){

                    @Override
                    public boolean contains(@NotNull VirtualFile file) {
                        return AnalysisScope.this.myFilesSet.contains(file);
                    }

                    @Override
                    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                        return 0;
                    }

                    @Override
                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        return false;
                    }

                    @Override
                    public boolean isSearchInLibraries() {
                        return false;
                    }
                };
            }
        }
        LOG.error("invalid type " + this.myType);
        return GlobalSearchScope.EMPTY_SCOPE;
    }

    public boolean isAnalyzeTestsByDefault() {
        switch (this.myType) {
            case 2: {
                return ProjectRootManager.getInstance(this.myElement.getProject()).getFileIndex().isInTestSourceContent(((PsiDirectory)this.myElement).getVirtualFile());
            }
            case 3: {
                PsiFile containingFile = this.myElement.getContainingFile();
                return ProjectRootManager.getInstance(containingFile.getProject()).getFileIndex().isInTestSourceContent(containingFile.getVirtualFile());
            }
            case 4: {
                return AnalysisScope.isTestOnly(this.myModule);
            }
            case 7: {
                for (Module module : this.myModules) {
                    if (AnalysisScope.isTestOnly(module)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTestOnly(@NotNull Module module) {
        return ModuleRootManager.getInstance(module).getSourceRootUrls(false).length == 0;
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }

    public void setFilter(GlobalSearchScope filter) {
        this.myFilter = filter;
    }

    public static @interface Type {
    }
}

