/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.AppCompatCallDetector;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.DetectMissingPrefix;
import com.android.tools.lint.checks.DosLineEndingDetector;
import com.android.tools.lint.checks.DuplicateResourceDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.checks.IncludeDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.MissingClassDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.PropertyFileDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.SharedPrefsDetector;
import com.android.tools.lint.checks.SignatureOrSystemDetector;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TitleDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UseCompoundDrawableDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.WrongCallDetector;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Beta
public abstract class Reporter {
    protected final LintCliClient mClient;
    protected final File mOutput;
    protected String mTitle = "Lint Report";
    protected boolean mSimpleFormat;
    protected boolean mBundleResources;
    protected Map<String, String> mUrlMap;
    protected File mResources;
    protected final Map<File, String> mResourceUrl = new HashMap<File, String>();
    protected final Map<String, File> mNameToFile = new HashMap<String, File>();
    protected boolean mDisplayEmpty = true;
    private static Set<Issue> sAdtFixes;
    private static Set<Issue> sStudioFixes;

    public abstract void write(int var1, int var2, List<Warning> var3) throws IOException;

    protected Reporter(LintCliClient client, File output) {
        this.mClient = client;
        this.mOutput = output;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setBundleResources(boolean bundleResources) {
        this.mBundleResources = bundleResources;
        this.mSimpleFormat = false;
    }

    public void setSimpleFormat(boolean simpleFormat) {
        this.mSimpleFormat = simpleFormat;
    }

    public boolean isSimpleFormat() {
        return this.mSimpleFormat;
    }

    String getUrl(File file) {
        String relativePath;
        String url;
        if (this.mBundleResources && !this.mSimpleFormat && (url = this.getRelativeResourceUrl(file)) != null) {
            return url;
        }
        if (this.mUrlMap != null) {
            String path = file.getAbsolutePath();
            String pathUrl = Reporter.encodeUrl(path);
            for (Map.Entry<String, String> entry : this.mUrlMap.entrySet()) {
                String prefix = entry.getKey();
                String prefixUrl = Reporter.encodeUrl(prefix);
                if (!pathUrl.startsWith(prefixUrl)) continue;
                String relative = pathUrl.substring(prefixUrl.length());
                return entry.getValue() + relative;
            }
        }
        if (file.isAbsolute() && (relativePath = Reporter.getRelativePath(this.mOutput.getParentFile(), file)) != null) {
            relativePath = relativePath.replace(File.separatorChar, '/');
            return Reporter.encodeUrl(relativePath);
        }
        try {
            return SdkUtils.fileToUrlString((File)file);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static String encodeUrl(String url) {
        try {
            url = url.replace('\\', '/');
            return URLEncoder.encode(url, "UTF-8").replace("%2F", "/");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Invalid string " + e.getLocalizedMessage());
            return url;
        }
    }

    public void setUrlMap(@Nullable Map<String, String> urlMap) {
        this.mUrlMap = urlMap;
    }

    File getResourceDir() {
        if (this.mResources == null && this.mBundleResources) {
            this.mResources = this.computeResourceDir();
            if (this.mResources == null) {
                this.mBundleResources = false;
            }
        }
        return this.mResources;
    }

    File computeResourceDir() {
        File resources;
        String fileName = this.mOutput.getName();
        int dot = fileName.indexOf(46);
        if (dot != -1) {
            fileName = fileName.substring(0, dot);
        }
        if (!(resources = new File(this.mOutput.getParentFile(), fileName + "_files")).exists() && !resources.mkdir()) {
            resources = null;
        }
        return resources;
    }

    protected String getRelativeResourceUrl(File file) {
        String resource = this.mResourceUrl.get(file);
        if (resource != null) {
            return resource;
        }
        String name = file.getName();
        if (!LintUtils.endsWith((String)name, (String)".png") || LintUtils.endsWith((String)name, (String)".9.png")) {
            return null;
        }
        File resourceDir = this.getResourceDir();
        if (resourceDir != null) {
            String base = file.getName();
            File path = this.mNameToFile.get(base);
            if (path != null && !path.equals(file)) {
                for (int i = 0; i < 100 && (path = this.mNameToFile.get(base = '_' + base)) != null && !path.equals(file); ++i) {
                }
            }
            File target = new File(resourceDir, base);
            try {
                Files.copy((File)file, (File)target);
            }
            catch (IOException e) {
                return null;
            }
            return resourceDir.getName() + '/' + Reporter.encodeUrl(base);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addLocalResources(URL url) throws IOException {
        File resourceDir = this.computeResourceDir();
        if (resourceDir != null) {
            String base = url.getFile();
            base = base.substring(base.lastIndexOf(47) + 1);
            this.mNameToFile.put(base, new File(url.toExternalForm()));
            File target = new File(resourceDir, base);
            Closer closer = Closer.create();
            try {
                FileOutputStream output = (FileOutputStream)closer.register((Closeable)new FileOutputStream(target));
                InputStream input = (InputStream)closer.register((Closeable)url.openStream());
                ByteStreams.copy((InputStream)input, (OutputStream)output);
            }
            catch (Throwable e) {
                closer.rethrow(e);
            }
            finally {
                closer.close();
            }
            return resourceDir.getName() + '/' + Reporter.encodeUrl(base);
        }
        return null;
    }

    @Nullable
    static String getRelativePath(File base, File file) {
        int len;
        String filePathToCompare;
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        basePath = !basePath.isEmpty() && basePath.charAt(basePath.length() - 1) == File.separatorChar ? basePath : basePath + File.separatorChar;
        boolean caseSensitive = SdkConstants.CURRENT_PLATFORM == 1;
        Locale l = Locale.getDefault();
        String basePathToCompare = caseSensitive ? basePath : basePath.toLowerCase(l);
        if (basePathToCompare.equals(!(filePathToCompare = caseSensitive ? filePath : filePath.toLowerCase(l)).isEmpty() && filePathToCompare.charAt(filePathToCompare.length() - 1) == File.separatorChar ? filePathToCompare : filePathToCompare + File.separatorChar)) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != File.separatorChar) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != File.separatorChar) continue;
            relativePath.append("..");
            relativePath.append(File.separatorChar);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    public boolean isDisplayEmpty() {
        return this.mDisplayEmpty;
    }

    public void setDisplayEmpty(boolean displayEmpty) {
        this.mDisplayEmpty = displayEmpty;
    }

    public static boolean hasAutoFix(@NonNull QuickfixHandler tool, Issue issue) {
        if (tool == QuickfixHandler.ADT) {
            if (sAdtFixes == null) {
                sAdtFixes = Sets.newHashSet((Object[])new Issue[]{InefficientWeightDetector.INEFFICIENT_WEIGHT, AccessibilityDetector.ISSUE, InefficientWeightDetector.BASELINE_WEIGHTS, HardcodedValuesDetector.ISSUE, UselessViewDetector.USELESS_LEAF, UselessViewDetector.USELESS_PARENT, PxUsageDetector.PX_ISSUE, TextFieldDetector.ISSUE, SecurityDetector.EXPORTED_SERVICE, DetectMissingPrefix.MISSING_NAMESPACE, ScrollViewChildDetector.ISSUE, ObsoleteLayoutParamsDetector.ISSUE, TypographyDetector.DASHES, TypographyDetector.ELLIPSIS, TypographyDetector.FRACTIONS, TypographyDetector.OTHER, TypographyDetector.QUOTES, UseCompoundDrawableDetector.ISSUE, ApiDetector.UNSUPPORTED, ApiDetector.INLINED, TypoDetector.ISSUE, ManifestDetector.ALLOW_BACKUP, MissingIdDetector.ISSUE, TranslationDetector.MISSING, DosLineEndingDetector.ISSUE});
            }
            return sAdtFixes.contains(issue);
        }
        if (tool == QuickfixHandler.STUDIO) {
            if (sStudioFixes == null) {
                sStudioFixes = Sets.newHashSet((Object[])new Issue[]{AccessibilityDetector.ISSUE, AlwaysShowActionDetector.ISSUE, ApiDetector.INLINED, ApiDetector.UNSUPPORTED, AppCompatCallDetector.ISSUE, ByteOrderMarkDetector.BOM, CommentDetector.STOP_SHIP, DetectMissingPrefix.MISSING_NAMESPACE, DuplicateResourceDetector.TYPE_MISMATCH, GradleDetector.COMPATIBILITY, GradleDetector.DEPENDENCY, GradleDetector.DEPRECATED, GradleDetector.PLUS, GradleDetector.REMOTE_VERSION, GradleDetector.STRING_INTEGER, GridLayoutDetector.ISSUE, IncludeDetector.ISSUE, InefficientWeightDetector.BASELINE_WEIGHTS, InefficientWeightDetector.INEFFICIENT_WEIGHT, InefficientWeightDetector.ORIENTATION, JavaPerformanceDetector.USE_VALUE_OF, ManifestDetector.ALLOW_BACKUP, ManifestDetector.APPLICATION_ICON, ManifestDetector.MIPMAP, ManifestDetector.MOCK_LOCATION, ManifestDetector.TARGET_NEWER, MissingClassDetector.INNERCLASS, MissingIdDetector.ISSUE, NamespaceDetector.RES_AUTO, ObsoleteLayoutParamsDetector.ISSUE, PropertyFileDetector.ESCAPE, PropertyFileDetector.HTTP, PxUsageDetector.DP_ISSUE, PxUsageDetector.PX_ISSUE, ScrollViewChildDetector.ISSUE, SecurityDetector.EXPORTED_SERVICE, SharedPrefsDetector.ISSUE, SignatureOrSystemDetector.ISSUE, SupportAnnotationDetector.CHECK_PERMISSION, SupportAnnotationDetector.CHECK_RESULT, TextFieldDetector.ISSUE, TextViewDetector.SELECTABLE, TitleDetector.ISSUE, TypoDetector.ISSUE, TypographyDetector.DASHES, TypographyDetector.ELLIPSIS, TypographyDetector.FRACTIONS, TypographyDetector.OTHER, TypographyDetector.QUOTES, UselessViewDetector.USELESS_LEAF, Utf8Detector.ISSUE, WrongCallDetector.ISSUE, WrongCaseDetector.WRONG_CASE});
            }
            return sStudioFixes.contains(issue);
        }
        return false;
    }

    static enum QuickfixHandler {
        STUDIO,
        ADT;


        public boolean hasAutoFix(Issue issue) {
            return Reporter.hasAutoFix(this, issue);
        }
    }
}

