/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.builder.model.AndroidLibrary;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public abstract class ManifestProcessorTask
extends IncrementalTask {
    private File manifestOutputFile;
    private File aaptFriendlyManifestOutputFile;
    private File instantRunManifestOutputFile;

    @OutputFile
    public File getManifestOutputFile() {
        return this.manifestOutputFile;
    }

    public void setManifestOutputFile(File manifestOutputFile) {
        this.manifestOutputFile = manifestOutputFile;
    }

    @OutputFile
    @Optional
    public File getInstantRunManifestOutputFile() {
        return this.instantRunManifestOutputFile;
    }

    public void setInstantRunManifestOutputFile(File instantRunManifestOutputFile) {
        this.instantRunManifestOutputFile = instantRunManifestOutputFile;
    }

    @OutputFile
    @Optional
    public File getAaptFriendlyManifestOutputFile() {
        return this.aaptFriendlyManifestOutputFile;
    }

    public void setAaptFriendlyManifestOutputFile(File aaptFriendlyManifestOutputFile) {
        this.aaptFriendlyManifestOutputFile = aaptFriendlyManifestOutputFile;
    }

    protected static String serializeMap(Map<String, Object> mapToSerialize) {
        final Joiner keyValueJoiner = Joiner.on((String)":");
        return Joiner.on((String)",").join((Iterable)Ordering.natural().sortedCopy(Iterables.transform(mapToSerialize.entrySet(), (Function)new Function<Map.Entry<String, Object>, String>(){

            public String apply(Map.Entry<String, Object> input) {
                return keyValueJoiner.join((Object)input.getKey(), input.getValue(), new Object[0]);
            }
        })));
    }

    public File getOutputFile() {
        File aaptFriendlyManifest = this.getAaptFriendlyManifestOutputFile();
        return aaptFriendlyManifest != null ? aaptFriendlyManifest : this.getManifestOutputFile();
    }

    protected static void fillManifestList(AndroidLibrary androidLibrary, List<File> manifestList) {
        if (androidLibrary.isOptional()) {
            return;
        }
        manifestList.add(androidLibrary.getManifest());
        for (AndroidLibrary dependency : androidLibrary.getLibraryDependencies()) {
            ManifestProcessorTask.fillManifestList(dependency, manifestList);
        }
    }
}

