/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.tasks.AbstractAndroidCompile;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.annotations.ApiDatabase;
import com.android.build.gradle.tasks.annotations.Extractor;
import com.android.tools.lint.EcjParser;
import com.android.tools.lint.EcjSourceFile;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

@ParallelizableTask
public class ExtractAnnotations
extends AbstractAndroidCompile {
    private BaseVariantData variant;
    private List<String> bootClasspath;
    private File typedefFile;
    private File output;
    private File proguard;
    private File apiFilter;
    private List<File> mergeJars;
    private String encoding;
    private File classDir;
    private boolean allowErrors = true;

    public BaseVariantData getVariant() {
        return this.variant;
    }

    public void setVariant(BaseVariantData variant) {
        this.variant = variant;
    }

    @Input
    @Optional
    public List<String> getBootClasspath() {
        return this.bootClasspath;
    }

    public void setBootClasspath(List<String> bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    @Optional
    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @Optional
    @OutputFile
    public File getProguard() {
        return this.proguard;
    }

    public void setProguard(File proguard) {
        this.proguard = proguard;
    }

    @Optional
    @OutputFile
    public File setTypedefFile() {
        return this.typedefFile;
    }

    public void getTypedefFile(File typedefFile) {
        this.typedefFile = typedefFile;
    }

    @Optional
    @InputFile
    public File getApiFilter() {
        return this.apiFilter;
    }

    public void setApiFilter(File apiFilter) {
        this.apiFilter = apiFilter;
    }

    @Optional
    @InputFile
    public List<File> getMergeJars() {
        return this.mergeJars;
    }

    public void setMergeJars(List<File> mergeJars) {
        this.mergeJars = mergeJars;
    }

    @Optional
    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Optional
    @InputDirectory
    public File getClassDir() {
        return this.classDir;
    }

    public void setClassDir(File classDir) {
        this.classDir = classDir;
    }

    @Input
    public boolean isAllowErrors() {
        return this.allowErrors;
    }

    public void setAllowErrors(boolean allowErrors) {
        this.allowErrors = allowErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected void compile() {
        if (!this.hasAndroidAnnotations()) {
            return;
        }
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        EcjParser.EcjResult result = this.parseSources();
        Collection parsedUnits = result.getCompilationUnits();
        try {
            if (!this.allowErrors) {
                for (CompilationUnitDeclaration unit : parsedUnits) {
                    CategorizedProblem[] problems = unit.compilationResult().getAllProblems();
                    for (CategorizedProblem problem : problems) {
                        if (!problem.isError()) continue;
                        this.getLogger().warn("Not extracting annotations (compilation problems encountered)\nError: " + new String(problem.getOriginatingFileName()) + ":" + problem.getSourceLineNumber() + ": " + problem.getMessage());
                        return;
                    }
                }
            }
            ApiDatabase database = null;
            if (this.apiFilter != null && this.apiFilter.exists()) {
                try {
                    database = new ApiDatabase(this.apiFilter);
                }
                catch (IOException e) {
                    throw new BuildException("Could not open API database " + this.apiFilter, (Throwable)e);
                }
            }
            boolean displayInfo = this.getProject().getLogger().isEnabled(LogLevel.INFO);
            Extractor extractor = new Extractor(database, this.classDir, displayInfo, false, false);
            extractor.extractFromProjectSource(parsedUnits);
            if (this.mergeJars != null) {
                for (File jar : this.mergeJars) {
                    extractor.mergeExisting(jar);
                }
            }
            extractor.export(this.output, this.proguard);
            if (this.typedefFile != null) {
                extractor.writeTypedefFile(this.typedefFile);
            } else {
                extractor.removeTypedefClasses();
            }
        }
        finally {
            result.dispose();
        }
    }

    @Input
    public boolean hasAndroidAnnotations() {
        return this.variant.getVariantDependency().isAnnotationsPresent();
    }

    private EcjParser.EcjResult parseSources() {
        final ArrayList sourceUnits = Lists.newArrayListWithExpectedSize((int)100);
        this.getSource().visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileVisitDetails) {
                File file = fileVisitDetails.getFile();
                String path = file.getPath();
                if (path.endsWith(".java") && file.isFile()) {
                    char[] contents;
                    try {
                        contents = Util.getFileCharContent((File)file, (String)ExtractAnnotations.this.encoding);
                    }
                    catch (IOException e) {
                        ExtractAnnotations.this.getLogger().warn("Could not read file", (Throwable)e);
                        return;
                    }
                    EcjSourceFile unit = new EcjSourceFile(contents, file, ExtractAnnotations.this.encoding);
                    sourceUnits.add(unit);
                }
            }
        });
        ArrayList jars = Lists.newArrayList();
        if (this.bootClasspath != null) {
            jars.addAll(this.bootClasspath);
        }
        if (this.getClasspath() != null) {
            for (File jar : this.getClasspath()) {
                jars.add(jar.getPath());
            }
        }
        CompilerOptions options = EcjParser.createCompilerOptions();
        options.docCommentSupport = false;
        options.complianceLevel = options.sourceLevel = ExtractAnnotations.getLanguageLevel(this.getSourceCompatibility());
        options.targetJDK = options.sourceLevel;
        options.originalComplianceLevel = options.sourceLevel;
        options.originalSourceLevel = options.sourceLevel;
        options.inlineJsrBytecode = true;
        return EcjParser.parse((CompilerOptions)options, (List)sourceUnits, (List)jars, null);
    }

    private static long getLanguageLevel(String version) {
        if ("1.6".equals(version)) {
            return EcjParser.getLanguageLevel((int)1, (int)6);
        }
        if ("1.7".equals(version)) {
            return EcjParser.getLanguageLevel((int)1, (int)7);
        }
        if ("1.5".equals(version)) {
            return EcjParser.getLanguageLevel((int)1, (int)5);
        }
        if ("1.8".equals(version)) {
            return EcjParser.getLanguageLevel((int)1, (int)8);
        }
        return EcjParser.getLanguageLevel((int)1, (int)7);
    }
}

