/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.external.gson.NativeLibraryValue;
import com.android.build.gradle.external.gson.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.BuildCommandException;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;

public class ExternalNativeBuildTaskUtils {
    static File getOutputFolder(File jsonFolder, String abi) {
        return new File(jsonFolder, abi);
    }

    public static File getOutputJson(File jsonFolder, String abi) {
        return new File(ExternalNativeBuildTaskUtils.getOutputFolder(jsonFolder, abi), "android_gradle_build.json");
    }

    public static List<File> getOutputJsons(File jsonFolder, Collection<String> abis) {
        ArrayList outputs = Lists.newArrayList();
        for (String abi : abis) {
            outputs.add(ExternalNativeBuildTaskUtils.getOutputJson(jsonFolder, abi));
        }
        return outputs;
    }

    static NativeBuildConfigValue getNativeBuildConfigValue(File json, String groupName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupName) ? 1 : 0) != 0, (String)"group name missing in", (Object[])new Object[]{json});
        Gson gson = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).create();
        List lines = Files.readLines((File)json, (Charset)Charsets.UTF_8);
        NativeBuildConfigValue config = (NativeBuildConfigValue)gson.fromJson(Joiner.on((String)"\n").join((Iterable)lines), NativeBuildConfigValue.class);
        if (config.libraries == null) {
            return config;
        }
        for (NativeLibraryValue library : config.libraries.values()) {
            library.groupName = groupName;
        }
        return config;
    }

    public static Collection<NativeBuildConfigValue> getNativeBuildConfigValues(Collection<File> jsons, String groupName) throws IOException {
        ArrayList configValues = Lists.newArrayList();
        for (File json : jsons) {
            configValues.add(ExternalNativeBuildTaskUtils.getNativeBuildConfigValue(json, groupName));
        }
        return configValues;
    }

    public static boolean shouldRegenerateOutOfDateJsons(Project project) {
        return AndroidGradleOptions.buildModelOnly(project) || AndroidGradleOptions.buildModelOnlyAdvanced(project) || AndroidGradleOptions.invokedFromIde(project) || AndroidGradleOptions.refreshExternalNativeModel(project);
    }

    public static boolean isExternalNativeBuildEnabled(CoreExternalNativeBuild config) {
        return config.getNdkBuild().getPath() != null || config.getCmake().getPath() != null;
    }

    public static ExternalNativeBuildProjectPathResolution getProjectPath(CoreExternalNativeBuild config) {
        Map<NativeBuildSystem, File> externalProjectPaths = ExternalNativeBuildTaskUtils.getExternalBuildExplicitPaths(config);
        if (externalProjectPaths.size() > 1) {
            return new ExternalNativeBuildProjectPathResolution(null, null, "More than one externalNativeBuild path specified");
        }
        if (externalProjectPaths.isEmpty()) {
            return new ExternalNativeBuildProjectPathResolution(null, null, null);
        }
        return new ExternalNativeBuildProjectPathResolution(externalProjectPaths.keySet().iterator().next(), externalProjectPaths.values().iterator().next(), null);
    }

    private static Map<NativeBuildSystem, File> getExternalBuildExplicitPaths(CoreExternalNativeBuild config) {
        EnumMap<NativeBuildSystem, File> map = new EnumMap<NativeBuildSystem, File>(NativeBuildSystem.class);
        File cmake = config.getCmake().getPath();
        File ndkBuild = config.getNdkBuild().getPath();
        if (cmake != null) {
            map.put(NativeBuildSystem.CMAKE, cmake);
        }
        if (ndkBuild != null) {
            map.put(NativeBuildSystem.NDK_BUILD, ndkBuild);
        }
        return map;
    }

    public static String executeBuildProcessAndLogError(AndroidBuilder androidBuilder, ProcessInfo process) throws BuildCommandException {
        ExecuteBuildProcessLogger logger = new ExecuteBuildProcessLogger(androidBuilder.getLogger());
        try {
            androidBuilder.executeProcess(process, (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)logger)).rethrowFailure().assertNormalExitValue();
            return logger.getOutput();
        }
        catch (ProcessException e) {
            String combinedMessage = String.format("%s\n%s", e.getMessage(), logger.getOutput());
            throw new BuildCommandException(combinedMessage);
        }
    }

    private static class ExecuteBuildProcessLogger
    implements ILogger {
        private final StringBuilder output = new StringBuilder();
        private final ILogger logger;

        private ExecuteBuildProcessLogger(ILogger logger) {
            this.logger = logger;
        }

        private String getOutput() {
            return this.output.toString();
        }

        public void error(Throwable t, String msgFormat, Object ... args) {
            if (msgFormat != null) {
                this.output.append(msgFormat);
            }
            this.logger.error(t, msgFormat, args);
        }

        public void warning(String msgFormat, Object ... args) {
            this.output.append(msgFormat);
            this.logger.warning(msgFormat, args);
        }

        public void info(String msgFormat, Object ... args) {
            this.output.append(msgFormat);
            this.logger.info(msgFormat, args);
        }

        public void verbose(String msgFormat, Object ... args) {
            this.output.append(msgFormat);
            this.logger.verbose(msgFormat, args);
        }
    }

    public static class ExternalNativeBuildProjectPathResolution {
        public final String errorText;
        public final NativeBuildSystem buildSystem;
        public final File makeFile;

        private ExternalNativeBuildProjectPathResolution(NativeBuildSystem buildSystem, File makeFile, String errorText) {
            Preconditions.checkArgument((makeFile == null || buildSystem != null ? 1 : 0) != 0, (Object)"Expected path and buildSystem together, no taskClass");
            Preconditions.checkArgument((makeFile != null || buildSystem == null ? 1 : 0) != 0, (Object)"Expected path and buildSystem together, no path");
            Preconditions.checkArgument((makeFile == null || errorText == null ? 1 : 0) != 0, (Object)"Expected path or error but both existed");
            this.buildSystem = buildSystem;
            this.makeFile = makeFile;
            this.errorText = errorText;
        }
    }
}

