/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import org.gradle.api.Task;

public abstract class BaseVariantOutputData
implements VariantOutput {
    private static final String UNIVERSAL = "universal";
    public final BaseVariantData<?> variantData;
    private final ApkOutputFile mainApkOutputFile;
    private boolean multiOutput = false;
    public ManifestProcessorTask manifestProcessorTask;
    public ProcessAndroidResources processResourcesTask;
    public PackageSplitRes packageSplitResourcesTask;
    public PackageSplitAbi packageSplitAbiTask;
    public PackageAndroidArtifact packageAndroidArtifactTask;
    public Task assembleTask;
    private final VariantOutputScope scope;

    public BaseVariantOutputData(OutputFile.OutputType outputType, Collection<FilterData> filters, BaseVariantData<?> variantData) {
        this.variantData = variantData;
        this.mainApkOutputFile = new ApkOutputFile(outputType, filters, this::getOutputFile);
        this.scope = new VariantOutputScope(variantData.getScope(), this);
    }

    public ApkOutputFile getMainOutputFile() {
        return this.mainApkOutputFile;
    }

    public abstract void setOutputFile(File var1);

    public abstract File getOutputFile();

    public abstract ImmutableList<ApkOutputFile> getOutputs();

    public String getFullName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getFullName();
        }
        return this.variantData.getVariantConfiguration().computeFullNameWithSplits(this.getFilterName());
    }

    public String getBaseName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getBaseName();
        }
        return this.variantData.getVariantConfiguration().computeBaseNameWithSplits(this.getFilterName());
    }

    public String getDirName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getDirName();
        }
        return this.variantData.getVariantConfiguration().computeDirNameWithSplits(new String[]{this.mainApkOutputFile.getFilter(OutputFile.DENSITY), this.mainApkOutputFile.getFilter(OutputFile.ABI)});
    }

    private String getFilterName() {
        String abiFilter;
        if (this.mainApkOutputFile.getFilters().isEmpty()) {
            return UNIVERSAL;
        }
        StringBuilder sb = new StringBuilder();
        String densityFilter = this.mainApkOutputFile.getFilter(OutputFile.DENSITY);
        if (densityFilter != null) {
            sb.append(densityFilter);
        }
        if ((abiFilter = this.mainApkOutputFile.getFilter(OutputFile.ABI)) != null) {
            if (sb.length() > 0) {
                sb.append(StringHelper.capitalize((String)abiFilter));
            } else {
                sb.append(abiFilter);
            }
        }
        return sb.toString();
    }

    public File getSplitFolder() {
        return this.getOutputFile().getParentFile();
    }

    void setMultiOutput(boolean multiOutput) {
        this.multiOutput = multiOutput;
    }

    public VariantOutputScope getScope() {
        return this.scope;
    }
}

