/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.model.AndroidLibraryImpl;
import com.android.build.gradle.internal.model.JavaLibraryImpl;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.caching.CreatingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DependenciesImpl
implements Dependencies,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final CreatingCache<AndroidLibrary, AndroidLibraryImpl> sLibCache = new CreatingCache(DependenciesImpl::convertAndroidLibrary);
    private static final CreatingCache<JavaLibrary, JavaLibraryImpl> sJarCache = new CreatingCache(DependenciesImpl::convertJarLibrary);
    private static final CreatingCache<JavaLibrary, JavaLibraryImpl> sFlatJarCache = new CreatingCache(DependenciesImpl::convertFlatJarLibrary);
    private final List<AndroidLibrary> libraries;
    private final List<JavaLibrary> javaLibraries;
    private final List<String> projects;
    private static int sModelLevel = 0;

    public static void setModelLevel(int modelLevel) {
        sModelLevel = modelLevel;
    }

    public static void clearCaches() {
        sLibCache.clear();
        sJarCache.clear();
        sFlatJarCache.clear();
    }

    static DependenciesImpl getEmpty() {
        return new DependenciesImpl((List<AndroidLibrary>)ImmutableList.of(), (List<JavaLibrary>)ImmutableList.of(), (List<String>)ImmutableList.of());
    }

    static DependenciesImpl cloneDependenciesForJavaArtifacts(Dependencies dependencies) {
        List<AndroidLibrary> libraries = Collections.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List<String> projects = Collections.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects);
    }

    static DependenciesImpl cloneDependencies(DependencyContainer dependencies, VariantConfiguration variantConfiguration, AndroidBuilder androidBuilder) {
        File supportJar;
        ArrayList clonedProjects = Lists.newArrayList();
        ImmutableList androidLibraries = dependencies.getAndroidDependencies();
        ArrayList clonedAndroidLibraries = Lists.newArrayListWithCapacity((int)androidLibraries.size());
        ImmutableList javaLibraries = dependencies.getJarDependencies();
        ImmutableList localJavaLibraries = dependencies.getLocalDependencies();
        ArrayList clonedJavaLibraries = Lists.newArrayListWithExpectedSize((int)(javaLibraries.size() + localJavaLibraries.size()));
        for (AndroidLibrary libImpl : androidLibraries) {
            AndroidLibrary clonedLib = (AndroidLibrary)sLibCache.get((Object)libImpl);
            if (clonedLib == null) continue;
            clonedAndroidLibraries.add(clonedLib);
        }
        if (sModelLevel < 2) {
            for (AndroidLibrary androidLibrary : androidLibraries) {
                if (androidLibrary.getProject() != null) continue;
                DependenciesImpl.handleFlatClonedAndroidLib(androidLibrary, clonedJavaLibraries, clonedProjects);
            }
        }
        for (JavaLibrary javaLibrary : javaLibraries) {
            if (sModelLevel < 2) {
                DependenciesImpl.handleFlatClonedJavaLib(javaLibrary, clonedJavaLibraries, clonedProjects);
                continue;
            }
            JavaLibraryImpl clonedJavaLibrary = (JavaLibraryImpl)sJarCache.get((Object)javaLibrary);
            if (clonedJavaLibrary == null) continue;
            clonedJavaLibraries.add(clonedJavaLibrary);
        }
        for (JavaLibrary localJavaLibrary : localJavaLibraries) {
            clonedJavaLibraries.add(new JavaLibraryImpl(localJavaLibrary.getJarFile(), null, (List<JavaLibrary>)ImmutableList.of(), localJavaLibrary.getRequestedCoordinates(), localJavaLibrary.getResolvedCoordinates(), localJavaLibrary.isSkipped(), localJavaLibrary.isProvided()));
        }
        if (variantConfiguration.getRenderscriptSupportModeEnabled() && (supportJar = androidBuilder.getRenderScriptSupportJar()) != null) {
            clonedJavaLibraries.add(new JavaLibraryImpl(supportJar, null, (List<JavaLibrary>)ImmutableList.of(), null, (MavenCoordinates)new MavenCoordinatesImpl("com.android.support", "renderscript", androidBuilder.getTargetInfo().getBuildTools().getRevision().toString()), false, false));
        }
        return new DependenciesImpl(clonedAndroidLibraries, clonedJavaLibraries, clonedProjects);
    }

    private static void handleFlatClonedAndroidLib(AndroidLibrary androidLibrary, List<JavaLibrary> clonedJavaLibraries, List<String> clonedProjects) {
        for (JavaLibrary javaDependency : androidLibrary.getJavaDependencies()) {
            DependenciesImpl.handleFlatClonedJavaLib(javaDependency, clonedJavaLibraries, clonedProjects);
        }
        for (AndroidLibrary androidDependency : androidLibrary.getLibraryDependencies()) {
            DependenciesImpl.handleFlatClonedAndroidLib(androidDependency, clonedJavaLibraries, clonedProjects);
        }
    }

    private static void handleFlatClonedJavaLib(JavaLibrary javaLibrary, List<JavaLibrary> clonedJavaLibraries, List<String> clonedProjects) {
        boolean customArtifact;
        boolean bl = customArtifact = javaLibrary.getResolvedCoordinates().getClassifier() != null;
        if (!customArtifact && javaLibrary.getProject() != null) {
            clonedProjects.add(javaLibrary.getProject().intern());
        } else {
            JavaLibrary clonedJavaLib = (JavaLibrary)sFlatJarCache.get((Object)javaLibrary);
            if (clonedJavaLib != null && !clonedJavaLibraries.contains(clonedJavaLib)) {
                clonedJavaLibraries.add(clonedJavaLib);
            }
            for (JavaLibrary javaDependency : javaLibrary.getDependencies()) {
                DependenciesImpl.handleFlatClonedJavaLib(javaDependency, clonedJavaLibraries, clonedProjects);
            }
        }
    }

    private DependenciesImpl(List<AndroidLibrary> libraries, List<JavaLibrary> javaLibraries, List<String> projects) {
        this.libraries = libraries;
        this.javaLibraries = javaLibraries;
        this.projects = projects;
    }

    public Collection<AndroidLibrary> getLibraries() {
        return this.libraries;
    }

    public Collection<JavaLibrary> getJavaLibraries() {
        return this.javaLibraries;
    }

    public List<String> getProjects() {
        return this.projects;
    }

    private static AndroidLibraryImpl convertAndroidLibrary(AndroidLibrary libraryDependency) {
        boolean newDepModel = sModelLevel >= 2;
        Object clonedJavaLibraries = ImmutableList.of();
        Object clonedDeps = ImmutableList.of();
        if (newDepModel || libraryDependency.getProject() == null) {
            List deps = libraryDependency.getLibraryDependencies();
            clonedDeps = Lists.newArrayListWithCapacity((int)deps.size());
            for (AndroidLibrary child : deps) {
                AndroidLibrary clonedLib = (AndroidLibrary)sLibCache.get((Object)child);
                if (clonedLib == null) continue;
                clonedDeps.add(clonedLib);
            }
            if (newDepModel) {
                Collection jarDeps = libraryDependency.getJavaDependencies();
                clonedJavaLibraries = Lists.newArrayListWithCapacity((int)jarDeps.size());
                for (JavaLibrary javaLibrary : jarDeps) {
                    JavaLibraryImpl clonedJar = (JavaLibraryImpl)sJarCache.get((Object)javaLibrary);
                    if (clonedJar == null) continue;
                    clonedJavaLibraries.add(clonedJar);
                }
            }
        }
        Collection<File> localJarOverride = DependenciesImpl.findLocalJar(libraryDependency);
        return new AndroidLibraryImpl(libraryDependency, (List<AndroidLibrary>)clonedDeps, (Collection<JavaLibrary>)clonedJavaLibraries, localJarOverride);
    }

    private static JavaLibraryImpl convertJarLibrary(JavaLibrary javaLibrary) {
        List javaDependencies = javaLibrary.getDependencies();
        ArrayList clonedDependencies = Lists.newArrayListWithCapacity((int)javaDependencies.size());
        for (JavaLibrary javaDependency : javaDependencies) {
            JavaLibraryImpl clonedJar = (JavaLibraryImpl)sJarCache.get((Object)javaDependency);
            if (clonedJar == null) continue;
            clonedDependencies.add(clonedJar);
        }
        return new JavaLibraryImpl(javaLibrary.getJarFile(), javaLibrary.getProject(), clonedDependencies, javaLibrary.getRequestedCoordinates(), javaLibrary.getResolvedCoordinates(), javaLibrary.isSkipped(), javaLibrary.isProvided());
    }

    private static JavaLibraryImpl convertFlatJarLibrary(JavaLibrary javaLibrary) {
        return new JavaLibraryImpl(javaLibrary.getJarFile(), null, (List<JavaLibrary>)ImmutableList.of(), javaLibrary.getRequestedCoordinates(), javaLibrary.getResolvedCoordinates(), javaLibrary.isSkipped(), javaLibrary.isProvided());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<File> findLocalJar(AndroidLibrary library) {
        File explodedFolder = library.getFolder();
        if (explodedFolder.isDirectory()) {
            return library.getLocalJars();
        }
        File aarFile = library.getBundle();
        if (aarFile.isFile()) {
            ArrayList jarList = Lists.newArrayList();
            File jarsFolder = new File(explodedFolder, "jars");
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(aarFile);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry zipEntry = e.nextElement();
                    String name = zipEntry.getName();
                    if (!name.startsWith("libs/") || !name.endsWith(".jar")) continue;
                    jarList.add(new File(jarsFolder, name.replace('/', File.separatorChar)));
                }
                ArrayList arrayList = jarList;
                return arrayList;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DependenciesImpl{");
        sb.append("libraries=").append(this.libraries);
        sb.append(", javaLibraries=").append(this.javaLibraries);
        sb.append(", projects=").append(this.projects);
        sb.append('}');
        return sb.toString();
    }
}

