/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.core.MergedExternalNativeBuildOptions;
import com.android.build.gradle.internal.core.MergedJackOptions;
import com.android.build.gradle.internal.core.MergedJavaCompileOptions;
import com.android.build.gradle.internal.core.MergedNdkConfig;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreExternalNativeBuildOptions;
import com.android.build.gradle.internal.dsl.CoreJackOptions;
import com.android.build.gradle.internal.dsl.CoreJavaCompileOptions;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.Project;

public class GradleVariantConfiguration
extends VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> {
    private final Project project;
    private OptionalInt instantRunSupportStatusOverride = OptionalInt.empty();
    private final MergedNdkConfig mergedNdkConfig = new MergedNdkConfig();
    private final MergedJackOptions mergedJackOptions = new MergedJackOptions();
    private final MergedExternalNativeBuildOptions mergedExternalNativeBuildOptions = new MergedExternalNativeBuildOptions();
    private final MergedJavaCompileOptions mergedJavaCompileOptions = new MergedJavaCompileOptions();

    private GradleVariantConfiguration(Project project, VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> testedConfig, CoreProductFlavor defaultConfig, SourceProvider defaultSourceProvider, CoreBuildType buildType, SourceProvider buildTypeSourceProvider, VariantType type, CoreSigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (BuildType)buildType, buildTypeSourceProvider, type, testedConfig, (SigningConfig)signingConfigOverride);
        this.mergeOptions();
        this.project = project;
    }

    public GradleVariantConfiguration getMyTestConfig(SourceProvider defaultSourceProvider, SourceProvider buildTypeSourceProvider, VariantType type) {
        return new GradleVariantConfiguration(this.project, this, (CoreProductFlavor)this.getDefaultConfig(), defaultSourceProvider, (CoreBuildType)this.getBuildType(), buildTypeSourceProvider, type, this.getSigningConfig());
    }

    public static Builder getBuilderForExtension(AndroidConfig extension) {
        if (extension instanceof TestAndroidConfig) {
            return new TestModuleConfigurationBuilder();
        }
        return new VariantConfigurationBuilder();
    }

    private void mergeOptions() {
        this.computeMergedOptions(this.mergedJackOptions, CoreProductFlavor::getJackOptions, CoreBuildType::getJackOptions, MergedJackOptions::reset, MergedJackOptions::append);
        this.computeMergedOptions(this.mergedJavaCompileOptions, CoreProductFlavor::getJavaCompileOptions, CoreBuildType::getJavaCompileOptions, MergedJavaCompileOptions::reset, MergedJavaCompileOptions::append);
        this.computeMergedOptions(this.mergedNdkConfig, CoreProductFlavor::getNdkConfig, CoreBuildType::getNdkConfig, MergedNdkConfig::reset, MergedNdkConfig::append);
        this.computeMergedOptions(this.mergedExternalNativeBuildOptions, CoreProductFlavor::getExternalNativeBuildOptions, CoreBuildType::getExternalNativeBuildOptions, MergedExternalNativeBuildOptions::reset, MergedExternalNativeBuildOptions::append);
    }

    public VariantConfiguration addProductFlavor(CoreProductFlavor productFlavor, SourceProvider sourceProvider, String dimensionName) {
        Preconditions.checkNotNull((Object)productFlavor);
        Preconditions.checkNotNull((Object)sourceProvider);
        Preconditions.checkNotNull((Object)dimensionName);
        super.addProductFlavor((ProductFlavor)productFlavor, sourceProvider, dimensionName);
        this.mergeOptions();
        return this;
    }

    public CoreNdkOptions getNdkConfig() {
        return this.mergedNdkConfig;
    }

    public CoreExternalNativeBuildOptions getExternalNativeBuildOptions() {
        return this.mergedExternalNativeBuildOptions;
    }

    public Set<String> getSupportedAbis() {
        return this.mergedNdkConfig.getAbiFilters();
    }

    public boolean isMinifyEnabled() {
        VariantType type = this.getType();
        return ((CoreBuildType)this.getBuildType()).isMinifyEnabled() && (!type.isForTesting() || this.getTestedConfig().getType() != VariantType.LIBRARY);
    }

    public CoreJackOptions getJackOptions() {
        return this.mergedJackOptions;
    }

    public CoreSigningConfig getSigningConfig() {
        return (CoreSigningConfig)super.getSigningConfig();
    }

    private <CoreOptionT, MergedOptionT> void computeMergedOptions(MergedOptionT option, Function<CoreProductFlavor, CoreOptionT> productFlavorOptionGetter, Function<CoreBuildType, CoreOptionT> buildTypeOptionGetter, Consumer<MergedOptionT> reset, BiConsumer<MergedOptionT, CoreOptionT> append) {
        reset.accept(option);
        CoreOptionT defaultOption = productFlavorOptionGetter.apply((CoreProductFlavor)this.getDefaultConfig());
        if (defaultOption != null) {
            append.accept(option, defaultOption);
        }
        List flavors = this.getProductFlavors();
        for (int i = flavors.size() - 1; i >= 0; --i) {
            CoreOptionT flavorOption = productFlavorOptionGetter.apply((CoreProductFlavor)flavors.get(i));
            if (flavorOption == null) continue;
            append.accept(option, flavorOption);
        }
        CoreOptionT buildTypeOption = buildTypeOptionGetter.apply((CoreBuildType)this.getBuildType());
        if (buildTypeOption != null) {
            append.accept(option, buildTypeOption);
        }
    }

    public CoreJavaCompileOptions getJavaCompileOptions() {
        return this.mergedJavaCompileOptions;
    }

    public boolean isInstantRunSupported() {
        return this.getInstantRunSupportStatus() == 0;
    }

    public int getInstantRunSupportStatus() {
        if (this.instantRunSupportStatusOverride.isPresent()) {
            return this.instantRunSupportStatusOverride.getAsInt();
        }
        if (!((CoreBuildType)this.getBuildType()).isDebuggable()) {
            return 1;
        }
        if (this.getType().isForTesting()) {
            return 2;
        }
        if (this.getJackOptions().isEnabled().booleanValue()) {
            return 3;
        }
        return 0;
    }

    public void setInstantRunSupportStatusOverride(int instantRunSupportStatusOverride) {
        this.instantRunSupportStatusOverride = OptionalInt.of(instantRunSupportStatusOverride);
    }

    public List<String> getDefautGlslcArgs() {
        HashMap optionMap = Maps.newHashMap();
        for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getGlslcArgs()) {
            optionMap.put(GradleVariantConfiguration.getKey(option), option);
        }
        List flavors = this.getProductFlavors();
        for (int i = flavors.size() - 1; i >= 0; --i) {
            for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
        }
        for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getGlslcArgs()) {
            optionMap.put(GradleVariantConfiguration.getKey(option), option);
        }
        return Lists.newArrayList(optionMap.values());
    }

    public Map<String, List<String>> getScopedGlslcArgs() {
        HashMap scopedArgs = Maps.newHashMap();
        Set<String> keys = this.getScopedGlslcKeys();
        for (String key : keys) {
            HashMap optionMap = Maps.newHashMap();
            for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getScopedGlslcArgs().get((Object)key)) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            List flavors = this.getProductFlavors();
            for (int i = flavors.size() - 1; i >= 0; --i) {
                for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getGlslcArgs()) {
                    optionMap.put(GradleVariantConfiguration.getKey(option), option);
                }
                for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getScopedGlslcArgs().get((Object)key)) {
                    optionMap.put(GradleVariantConfiguration.getKey(option), option);
                }
            }
            for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getScopedGlslcArgs().get((Object)key)) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            scopedArgs.put(key, ImmutableList.copyOf(optionMap.values()));
        }
        return scopedArgs;
    }

    private Set<String> getScopedGlslcKeys() {
        HashSet keys = Sets.newHashSet();
        keys.addAll(((CoreProductFlavor)this.getDefaultConfig()).getShaders().getScopedGlslcArgs().keySet());
        for (CoreProductFlavor flavor : this.getProductFlavors()) {
            keys.addAll(flavor.getShaders().getScopedGlslcArgs().keySet());
        }
        keys.addAll(((CoreBuildType)this.getBuildType()).getShaders().getScopedGlslcArgs().keySet());
        return keys;
    }

    private static String getKey(String fullOption) {
        int pos = fullOption.lastIndexOf(61);
        if (pos == -1) {
            return fullOption;
        }
        return fullOption.substring(0, pos);
    }

    public String getVersionName() {
        String override = AndroidGradleOptions.getVersionNameOverride(this.project);
        if (override != null) {
            return override;
        }
        return super.getVersionName();
    }

    public int getVersionCode() {
        Integer override = AndroidGradleOptions.getVersionCodeOverride(this.project);
        if (override != null) {
            return override;
        }
        return super.getVersionCode();
    }

    private static class TestModuleConfigurationBuilder
    implements Builder {
        private TestModuleConfigurationBuilder() {
        }

        @Override
        public GradleVariantConfiguration create(Project project, CoreProductFlavor defaultConfig, SourceProvider defaultSourceProvider, CoreBuildType buildType, SourceProvider buildTypeSourceProvider, VariantType type, CoreSigningConfig signingConfigOverride) {
            return new GradleVariantConfiguration(project, null, defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, type, signingConfigOverride){

                public String getApplicationId() {
                    String applicationId = this.getMergedFlavor().getTestApplicationId();
                    if (Strings.isNullOrEmpty((String)applicationId)) {
                        applicationId = super.getApplicationId();
                    }
                    return applicationId;
                }

                public String getOriginalApplicationId() {
                    return this.getApplicationId();
                }

                public String getTestApplicationId() {
                    return this.getApplicationId();
                }

                @Override
                public GradleVariantConfiguration getMyTestConfig(SourceProvider defaultSourceProvider, SourceProvider buildTypeSourceProvider, VariantType type) {
                    throw new UnsupportedOperationException("Test modules have no test variants.");
                }
            };
        }
    }

    private static class VariantConfigurationBuilder
    implements Builder {
        private VariantConfigurationBuilder() {
        }

        @Override
        public GradleVariantConfiguration create(Project project, CoreProductFlavor defaultConfig, SourceProvider defaultSourceProvider, CoreBuildType buildType, SourceProvider buildTypeSourceProvider, VariantType type, CoreSigningConfig signingConfigOverride) {
            return new GradleVariantConfiguration(project, null, defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, type, signingConfigOverride);
        }
    }

    public static interface Builder {
        public GradleVariantConfiguration create(Project var1, CoreProductFlavor var2, SourceProvider var3, CoreBuildType var4, SourceProvider var5, VariantType var6, CoreSigningConfig var7);
    }
}

