/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.aapt;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.v1.AaptV1;
import com.android.builder.internal.aapt.v2.OutOfProcessAaptV2;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.TeeProcessOutputHandler;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.api.Project;

public final class AaptGradleFactory {
    private AaptGradleFactory() {
    }

    public static Aapt make(AndroidBuilder builder, VariantScope scope, File intermediateDir) {
        return AaptGradleFactory.make(builder, true, true, scope, intermediateDir);
    }

    public static Aapt make(AndroidBuilder builder, boolean crunchPng, boolean process9Patch, VariantScope scope, File intermediateDir) {
        return AaptGradleFactory.make(builder, (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new FilteringLogger(builder.getLogger())), crunchPng, process9Patch, scope.getGlobalScope().getProject(), scope.getVariantConfiguration().getType(), intermediateDir, scope.getGlobalScope().getExtension().getAaptOptions().getCruncherProcesses());
    }

    public static Aapt make(AndroidBuilder builder, boolean crunchPng, boolean process9Patch, Project project, VariantType variantType, File intermediateDir, int cruncherProcesses) {
        return AaptGradleFactory.make(builder, null, crunchPng, process9Patch, project, variantType, intermediateDir, cruncherProcesses);
    }

    public static Aapt make(AndroidBuilder builder, ProcessOutputHandler outputHandler, boolean crunchPng, boolean process9Patch, Project project, VariantType variantType, File intermediateDir, int cruncherProcesses) {
        TargetInfo target = builder.getTargetInfo();
        Preconditions.checkNotNull((Object)target, (Object)"target == null");
        BuildToolInfo buildTools = target.getBuildTools();
        TeeProcessOutputHandler teeOutputHandler = new TeeProcessOutputHandler(new ProcessOutputHandler[]{outputHandler, new LoggedProcessOutputHandler((ILogger)new FilteringLogger(builder.getLogger()))});
        if (AndroidGradleOptions.isAapt2Enabled(project) && BuildToolInfo.PathId.AAPT2.isPresentIn(buildTools.getRevision())) {
            return new OutOfProcessAaptV2(builder.getProcessExecutor(), (ProcessOutputHandler)teeOutputHandler, buildTools, intermediateDir, (ILogger)new FilteringLogger(builder.getLogger()));
        }
        AaptV1.PngProcessMode processMode = crunchPng && process9Patch ? AaptV1.PngProcessMode.ALL : (process9Patch ? AaptV1.PngProcessMode.NINE_PATCH_ONLY : AaptV1.PngProcessMode.NONE);
        return new AaptV1(builder.getProcessExecutor(), (ProcessOutputHandler)teeOutputHandler, buildTools, (ILogger)new FilteringLogger(builder.getLogger()), processMode, cruncherProcesses);
    }

    private static class FilteringLogger
    implements ILogger {
        private static final List<Pattern> IGNORED_WARNINGS = Lists.newArrayList((Object[])new Pattern[]{Pattern.compile("Not recognizing known sRGB profile that has been edited")});
        private final ILogger mDelegate;

        private FilteringLogger(ILogger delegate) {
            this.mDelegate = delegate;
        }

        public void error(Throwable t, String msgFormat, Object ... args) {
            if (msgFormat != null && FilteringLogger.shouldDowngrade(msgFormat, args)) {
                this.mDelegate.info(Strings.nullToEmpty((String)msgFormat), args);
            } else {
                this.mDelegate.error(t, msgFormat, args);
            }
        }

        public void warning(String msgFormat, Object ... args) {
            if (FilteringLogger.shouldDowngrade(msgFormat, args)) {
                this.mDelegate.info(msgFormat, args);
            } else {
                this.mDelegate.warning(msgFormat, args);
            }
        }

        public void info(String msgFormat, Object ... args) {
            this.mDelegate.info(msgFormat, args);
        }

        public void verbose(String msgFormat, Object ... args) {
            this.mDelegate.verbose(msgFormat, args);
        }

        private static boolean shouldDowngrade(String msgFormat, Object ... args) {
            String message = String.format(msgFormat, args);
            for (Pattern pattern : IGNORED_WARNINGS) {
                if (!pattern.matcher(message).find()) continue;
                return true;
            }
            return false;
        }
    }
}

