/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BootstrapClassLoaderUtil;
import com.intellij.openapi.application.PathManager;
import java.io.File;

public class BootstrapUITestRunner {
    private static final String UITESTS_ROOT = "plugins/android/ui-tests-dir";
    private static final String ANDROID_ROOT = "plugins/android/lib";
    private static final String RUNNER_CLASS = "com.android.tools.idea.tests.gui.framework.PlainJUnitRunnable";
    private static final String SUITE_CLASS = "com.android.tools.idea.tests.gui.GuiSanityTestSuite";

    private static String getTestClasspath() {
        String ideaHome = PathManager.getHomePath();
        StringBuilder classpath = new StringBuilder();
        classpath.append(new File(ideaHome, UITESTS_ROOT).getAbsolutePath());
        for (File entry : new File(ideaHome, ANDROID_ROOT).listFiles()) {
            if (!entry.isFile() || !entry.getName().endsWith(".jar")) continue;
            classpath.append(File.pathSeparator);
            classpath.append(entry.getAbsolutePath());
        }
        return classpath.toString();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("idea.additional.classpath", BootstrapUITestRunner.getTestClasspath());
        ClassLoader newClassLoader = BootstrapClassLoaderUtil.initClassLoader(true);
        Class<?> suiteClass = Class.forName(SUITE_CLASS, true, newClassLoader);
        Runnable runner = (Runnable)Class.forName(RUNNER_CLASS, true, newClassLoader).getConstructor(Class.class).newInstance(suiteClass);
        runner.run();
    }
}

