/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.managed.AndroidConfig;
import com.android.build.gradle.managed.BuildType;
import com.android.build.gradle.managed.ProductFlavor;
import com.android.build.gradle.model.AndroidBinary;
import com.android.build.gradle.model.NdkComponentModelPlugin;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.build.gradle.ndk.internal.NdkNamingScheme;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.nativeplatform.NativeBinarySpec;

public class StandaloneNdkComponentModelPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(NdkComponentModelPlugin.class);
    }

    public static class Rules
    extends RuleSource {
        @Validate
        public static void validateCompileSdkVersion(AndroidConfig androidConfig) {
            Preconditions.checkState((androidConfig.getCompileSdkVersion() != null && !androidConfig.getCompileSdkVersion().isEmpty() ? 1 : 0) != 0, (Object)"compileSdkVersion is not specified.");
        }

        @Mutate
        public static void copyOutputs(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<AndroidBinaryInternal> androidSpecs, @Path(value="buildDir") File buildDir) {
            for (AndroidBinaryInternal androidBinary : androidSpecs.values()) {
                for (NativeBinarySpec nativeBinarySpec : androidBinary.getNativeBinaries()) {
                    String copyTaskName = NdkNamingScheme.getTaskName(nativeBinarySpec, "copy", "Output");
                    tasks.create(copyTaskName, Copy.class, copy -> {
                        copy.from(new Object[]{new File(buildDir, NdkNamingScheme.getOutputDirectoryName(nativeBinary))});
                        copy.into((Object)new File(buildDir, NdkNamingScheme.getStandaloneOutputDirectoryName(nativeBinary)));
                        copy.dependsOn(new Object[]{NdkNamingScheme.getNdkBuildTaskName(nativeBinary)});
                    });
                    Rules.dependsOn(tasks, Rules.getAssembleTaskName((Named)androidBinary), copyTaskName);
                }
            }
        }

        @Mutate
        public static void createAssembleTasksForBuildTypes(ModelMap<Task> tasks, @Path(value="android.buildTypes") ModelMap<BuildType> buildTypes) {
            for (Named buildType : buildTypes.values()) {
                Rules.createAssembleTask(tasks, buildType);
                Rules.dependsOn(tasks, "assemble", Rules.getAssembleTaskName(buildType));
            }
        }

        @Mutate
        public static void createAssembleTasksForProductFlavors(ModelMap<Task> tasks, @Path(value="android.productFlavors") ModelMap<ProductFlavor> flavors) {
            if (!flavors.isEmpty()) {
                for (Named productFlavor : flavors.values()) {
                    Rules.createAssembleTask(tasks, productFlavor);
                    Rules.dependsOn(tasks, "assemble", Rules.getAssembleTaskName(productFlavor));
                }
            }
        }

        @Mutate
        public static void createAssembleTasksForBinaries(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<AndroidBinary> binaries) {
            for (AndroidBinary binary : binaries.values()) {
                String binaryAssembleTaskName = Rules.getAssembleTaskName((Named)binary);
                if (!binary.getProductFlavors().isEmpty()) {
                    Rules.createAssembleTask(tasks, (Named)binary);
                    Rules.dependsOn(tasks, Rules.getAssembleTaskName(binary.getBuildType()), binaryAssembleTaskName);
                    for (ProductFlavor flavor : binary.getProductFlavors()) {
                        Rules.dependsOn(tasks, Rules.getAssembleTaskName(flavor), binaryAssembleTaskName);
                    }
                    if (binary.getProductFlavors().size() > 1) {
                        Rules.createAssembleTaskForFlavorCombo(tasks, binary.getProductFlavors());
                        Rules.dependsOn(tasks, Rules.getAssembleTaskName(binary.getProductFlavors()), binaryAssembleTaskName);
                    }
                }
                tasks.named(binaryAssembleTaskName, task -> task.dependsOn(new Object[]{binary}));
            }
        }

        private static void dependsOn(ModelMap<Task> tasks, String dependee, String dependent) {
            tasks.named(dependee, task -> task.dependsOn(new Object[]{dependent}));
        }

        private static String getAssembleTaskName(Named dimension) {
            return "assemble" + StringHelper.capitalize((String)dimension.getName());
        }

        private static String getAssembleTaskName(List<? extends Named> dimensions) {
            return "assemble" + StringHelper.capitalize((String)ProductFlavorCombo.getFlavorComboName(dimensions));
        }

        private static void createAssembleTaskForFlavorCombo(ModelMap<Task> tasks, List<? extends Named> dimensions) {
            String flavorCombo = ProductFlavorCombo.getFlavorComboName(dimensions);
            String taskName = Rules.getAssembleTaskName(dimensions);
            tasks.create(taskName, task -> {
                task.setDescription("Assembles all builds for flavor combination: " + flavorCombo);
                task.setGroup("build");
            });
        }

        private static void createAssembleTask(ModelMap<Task> tasks, Named dimension) {
            String taskName = Rules.getAssembleTaskName(dimension);
            tasks.create(taskName, task -> {
                task.setDescription("Assembles all " + dimension.getName() + " builds.");
                task.setGroup("build");
            });
        }
    }
}

