/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.internal.model.NativeAndroidProjectImpl;
import com.android.build.gradle.internal.model.NativeArtifactImpl;
import com.android.build.gradle.internal.model.NativeFileImpl;
import com.android.build.gradle.internal.model.NativeFolderImpl;
import com.android.build.gradle.internal.model.NativeSettingsImpl;
import com.android.build.gradle.internal.model.NativeToolchainImpl;
import com.android.build.gradle.managed.NativeBuildConfig;
import com.android.build.gradle.managed.NativeLibrary;
import com.android.build.gradle.ndk.internal.NativeCompilerArgsUtil;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class NativeComponentModelBuilder
implements ToolingModelBuilder {
    private final ModelRegistry registry;
    private final Map<List<String>, NativeSettings> settingsMap = Maps.newHashMap();
    private int settingIndex = 0;
    private NativeBuildConfig config;
    private List<String> buildSystems;

    public NativeComponentModelBuilder(ModelRegistry registry) {
        this.registry = registry;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(NativeAndroidProject.class.getName());
    }

    private void initialize() {
        this.config = (NativeBuildConfig)this.registry.realize(new ModelPath("nativeBuildConfig"), ModelType.of(NativeBuildConfig.class));
        this.buildSystems = (List)this.registry.realize(new ModelPath("nativeBuildSystems"), ModelTypes.list((ModelType)ModelType.of(String.class)));
        this.settingIndex = 0;
    }

    public Object buildAll(String modelName, Project project) {
        this.initialize();
        List<NativeArtifact> artifacts = this.createNativeArtifacts();
        List<NativeToolchain> toolchains = this.createNativeToolchains();
        ImmutableList settings = ImmutableList.copyOf(this.settingsMap.values());
        Map<String, String> extensions = this.createFileExtensionMap();
        return new NativeAndroidProjectImpl("2.2.0", project.getName(), (Collection)ImmutableList.copyOf(this.config.getBuildFiles()), artifacts, toolchains, (Collection)settings, extensions, this.buildSystems, 0);
    }

    private List<NativeArtifact> createNativeArtifacts() {
        ArrayList artifacts = Lists.newArrayList();
        for (NativeLibrary lib : this.config.getLibraries()) {
            List folders = lib.getFolders().stream().map(src -> {
                Preconditions.checkNotNull((Object)src.getSrc());
                return new NativeFolderImpl(src.getSrc(), (Map)ImmutableMap.of((Object)"c", (Object)this.getSettingsName(NativeComponentModelBuilder.convertFlagFormat(src.getcFlags())), (Object)"c++", (Object)this.getSettingsName(NativeComponentModelBuilder.convertFlagFormat(src.getCppFlags()))), src.getWorkingDirectory());
            }).collect(Collectors.toList());
            List files = lib.getFiles().stream().map(src -> {
                Preconditions.checkNotNull((Object)src.getSrc());
                return new NativeFileImpl(src.getSrc(), this.getSettingsName(NativeComponentModelBuilder.convertFlagFormat(src.getFlags())), src.getWorkingDirectory());
            }).collect(Collectors.toList());
            Preconditions.checkNotNull((Object)lib.getToolchain());
            Preconditions.checkNotNull((Object)lib.getAssembleTaskName());
            Preconditions.checkNotNull((Object)lib.getOutput());
            Preconditions.checkNotNull((Object)lib.getAbi());
            Preconditions.checkNotNull((Object)lib.getArtifactName());
            NativeArtifactImpl artifact = new NativeArtifactImpl(lib.getName(), lib.getToolchain(), Strings.nullToEmpty((String)lib.getGroupName()), lib.getAssembleTaskName(), folders, files, (Collection)ImmutableList.copyOf(lib.getExportedHeaders()), lib.getOutput(), lib.getAbi(), lib.getArtifactName());
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private static List<String> convertFlagFormat(String flags) {
        if (flags == null) {
            return Lists.newArrayList();
        }
        return NativeCompilerArgsUtil.transform((Iterable)StringHelper.tokenizeString((String)flags));
    }

    private String getSettingsName(List<String> flags) {
        ImmutableList flagsCopy = ImmutableList.copyOf(flags);
        NativeSettings setting = this.settingsMap.get(flags);
        if (setting == null) {
            setting = new NativeSettingsImpl("setting" + this.settingIndex, (List)flagsCopy);
            this.settingsMap.put((List<String>)flagsCopy, setting);
            ++this.settingIndex;
        }
        return setting.getName();
    }

    private List<NativeToolchain> createNativeToolchains() {
        return this.config.getToolchains().values().stream().map(toolchain -> new NativeToolchainImpl(toolchain.getName(), toolchain.getCCompilerExecutable(), toolchain.getCppCompilerExecutable())).collect(Collectors.toList());
    }

    private Map<String, String> createFileExtensionMap() {
        HashMap extensions = Maps.newHashMap();
        for (String ext : this.config.getcFileExtensions()) {
            extensions.put(ext, "c");
        }
        for (String ext : this.config.getCppFileExtensions()) {
            extensions.put(ext, "c++");
        }
        return extensions;
    }
}

