/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.external.gson.NativeLibraryValue;
import com.android.build.gradle.external.gson.NativeSourceFileValue;
import com.android.build.gradle.external.gson.NativeSourceFolderValue;
import com.android.build.gradle.external.gson.NativeToolchainValue;
import com.android.build.gradle.managed.NativeBuildConfig;
import com.android.build.gradle.managed.NativeLibrary;
import com.android.build.gradle.managed.NativeSourceFile;
import com.android.build.gradle.managed.NativeSourceFolder;
import com.android.build.gradle.managed.NativeToolchain;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import org.gradle.model.internal.core.DuplicateModelException;

public class NativeBuildConfigGsonUtil {
    public static void copyToNativeBuildConfig(NativeBuildConfigValue value, NativeBuildConfig config) {
        if (value.buildFiles != null) {
            config.getBuildFiles().addAll(value.buildFiles);
        }
        if (value.cleanCommands != null) {
            config.getCleanCommands().addAll(value.cleanCommands);
        }
        if (value.libraries != null) {
            for (Map.Entry entry : value.libraries.entrySet()) {
                config.getLibraries().create((String)entry.getKey(), nativeLibrary -> NativeBuildConfigGsonUtil.copyToNativeLibrary((NativeLibraryValue)entry.getValue(), nativeLibrary));
            }
        }
        if (value.toolchains != null) {
            for (Map.Entry entry : value.toolchains.entrySet()) {
                try {
                    config.getToolchains().create((String)entry.getKey(), nativeToolchain -> NativeBuildConfigGsonUtil.copyToNativeToolchain((NativeToolchainValue)entry.getValue(), nativeToolchain));
                }
                catch (DuplicateModelException duplicateModelException) {}
            }
        }
        if (value.cFileExtensions != null) {
            config.getcFileExtensions().addAll(value.cFileExtensions);
        }
        if (value.cppFileExtensions != null) {
            config.getCppFileExtensions().addAll(value.cppFileExtensions);
        }
    }

    private static void copyToNativeSourceFolder(NativeSourceFolderValue value, NativeSourceFolder folder) {
        folder.setSrc(value.src);
        if (value.cFlags != null) {
            folder.setcFlags(value.cFlags);
        }
        if (value.cppFlags != null) {
            folder.setCppFlags(value.cppFlags);
        }
        folder.setWorkingDirectory(value.workingDirectory);
    }

    private static void copyToNativeSourceFile(NativeSourceFileValue value, NativeSourceFile file) {
        file.setSrc(value.src);
        if (value.flags != null) {
            file.setFlags(value.flags);
        }
        file.setWorkingDirectory(value.workingDirectory);
    }

    private static void copyToNativeLibrary(NativeLibraryValue value, NativeLibrary library) {
        if (value.buildCommand != null) {
            library.setBuildCommand(value.buildCommand);
        }
        if (value.buildType != null) {
            library.setBuildType(value.buildType);
        }
        library.setToolchain(value.toolchain);
        if (value.folders != null) {
            for (NativeSourceFolderValue folder : value.folders) {
                library.getFolders().create(nativeSourceFolder -> NativeBuildConfigGsonUtil.copyToNativeSourceFolder(folder, nativeSourceFolder));
            }
        }
        library.setGroupName(value.groupName);
        library.setAbi(value.abi);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)value.artifactName) ? 1 : 0) != 0);
        library.setArtifactName(value.artifactName);
        if (value.files != null) {
            for (NativeSourceFolderValue folder : value.files) {
                library.getFiles().create(arg_0 -> NativeBuildConfigGsonUtil.lambda$copyToNativeLibrary$3((NativeSourceFileValue)folder, arg_0));
            }
        }
        if (value.exportedHeaders != null) {
            library.getExportedHeaders().addAll(value.exportedHeaders);
        }
        library.setOutput(value.output);
    }

    private static void copyToNativeToolchain(NativeToolchainValue value, NativeToolchain toolchain) {
        toolchain.setCCompilerExecutable(value.cCompilerExecutable);
        toolchain.setCppCompilerExecutable(value.cppCompilerExecutable);
    }

    private static /* synthetic */ void lambda$copyToNativeLibrary$3(NativeSourceFileValue folder, NativeSourceFile nativeSourceFolder) {
        NativeBuildConfigGsonUtil.copyToNativeSourceFile(folder, nativeSourceFolder);
    }
}

