/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.coverage.JacocoOptions;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AdbOptions;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.managed.AndroidConfig;
import com.google.common.collect.Lists;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.internal.reflect.Instantiator;

public class AndroidConfigHelper {
    public static void configure(AndroidConfig model, ExtraModelInfo extraModelInfo, Instantiator instantiator) {
        model.setDefaultPublishConfig("release");
        model.setPublishNonDefault(false);
        model.setGeneratePureSplits(false);
        model.setDeviceProviders(Lists.newArrayList());
        model.setTestServers(Lists.newArrayList());
        model.setAaptOptions((AaptOptions)instantiator.newInstance(AaptOptions.class, new Object[0]));
        model.setDexOptions((DexOptions)instantiator.newInstance(DexOptions.class, new Object[]{extraModelInfo}));
        model.setLintOptions((LintOptions)instantiator.newInstance(LintOptions.class, new Object[0]));
        model.setTestOptions((TestOptions)instantiator.newInstance(TestOptions.class, new Object[0]));
        model.setCompileOptions((CompileOptions)instantiator.newInstance(CompileOptions.class, new Object[0]));
        model.setPackagingOptions((PackagingOptions)instantiator.newInstance(PackagingOptions.class, new Object[0]));
        model.setJacoco((JacocoOptions)instantiator.newInstance(JacocoOptions.class, new Object[0]));
        model.setAdbOptions((AdbOptions)instantiator.newInstance(AdbOptions.class, new Object[0]));
        model.setSplits((Splits)instantiator.newInstance(Splits.class, new Object[]{instantiator}));
        model.setLibraryRequests(Lists.newArrayList());
    }

    public static NamedDomainObjectContainer<AndroidSourceSet> createSourceSetsContainer(Project project, Instantiator instantiator, boolean isLibrary) {
        NamedDomainObjectContainer sourceSetsContainer = project.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(instantiator, project, isLibrary));
        sourceSetsContainer.whenObjectAdded(sourceSet -> {
            ConfigurationContainer configurations = project.getConfigurations();
            AndroidConfigHelper.createConfiguration(configurations, sourceSet.getCompileConfigurationName(), "Classpath for compiling the " + sourceSet.getName() + " sources.");
            String packageConfigDescription = isLibrary ? "Classpath only used when publishing '" + sourceSet.getName() + "'." : "Classpath packaged with the compiled '" + sourceSet.getName() + "' classes.";
            AndroidConfigHelper.createConfiguration(configurations, sourceSet.getPackageConfigurationName(), packageConfigDescription);
            AndroidConfigHelper.createConfiguration(configurations, sourceSet.getProvidedConfigurationName(), "Classpath for only compiling the " + sourceSet.getName() + " sources.");
            AndroidConfigHelper.createConfiguration(configurations, sourceSet.getWearAppConfigurationName(), "Link to a wear app to embed for object '" + sourceSet.getName() + "}'.");
            AndroidConfigHelper.createConfiguration(configurations, sourceSet.getAnnotationProcessorConfigurationName(), "Classpath for the annotation processor for '" + sourceSet.getName() + "'.");
            AndroidConfigHelper.createConfiguration(configurations, sourceSet.getWearAppConfigurationName(), "Link to a wear app to embed for object '${sourceSet.name}'.");
            sourceSet.setRoot(String.format("src/%s", sourceSet.getName()));
        });
        return sourceSetsContainer;
    }

    private static void createConfiguration(ConfigurationContainer configurations, String configurationName, String configurationDescription) {
        Configuration configuration = (Configuration)configurations.findByName(configurationName);
        if (configuration == null) {
            configuration = (Configuration)configurations.create(configurationName);
        }
    }
}

