/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertySuppressableInspectionBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedMessageFormatParameterInspection
extends PropertySuppressableInspectionBase {
    public static final String REGEXP = "regexp";

    @NotNull
    public String getGroupDisplayName() {
        return PropertiesBundle.message((String)"properties.files.inspection.group.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getDisplayName() {
        return PropertiesBundle.message((String)"unused.message.format.parameter.display.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "UnusedMessageFormatParameter";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        List properties = propertiesFile.getProperties();
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        for (IProperty property : properties) {
            String name = property.getName();
            if (name != null && (name.startsWith("log4j") || name.startsWith("regexp.") || name.endsWith(".regexp"))) continue;
            String value = property.getValue();
            HashSet<Integer> parameters = new HashSet<Integer>();
            if (value == null) continue;
            int index = value.indexOf(123);
            while (index != -1) {
                value = value.substring(index + 1);
                int comma = value.indexOf(44);
                int brace = value.indexOf(125);
                if (brace == -1) break;
                index = comma == -1 ? brace : Math.min(comma, brace);
                try {
                    parameters.add(new Integer(value.substring(0, index)));
                }
                catch (NumberFormatException e) {
                    break;
                }
                index = value.indexOf(123);
            }
            block4: for (Integer integer : parameters) {
                for (int i = 0; i < integer; ++i) {
                    LocalQuickFix[] localQuickFixArray;
                    if (parameters.contains(new Integer(i))) continue;
                    ASTNode[] nodes = property.getPsiElement().getNode().getChildren(null);
                    PsiElement valElement = nodes.length < 3 ? property.getPsiElement() : nodes[2].getPsi();
                    String message = PropertiesBundle.message((String)"unused.message.format.parameter.problem.descriptor", (Object[])new Object[]{integer.toString(), Integer.toString(i)});
                    String propertyKey = property.getKey();
                    if (isOnTheFly) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new RenameElementFix((PsiNamedElement)((Property)property), propertyKey == null ? REGEXP : propertyKey + "." + REGEXP);
                    } else {
                        localQuickFixArray = null;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    problemDescriptors.add(manager.createProblemDescriptor(valElement, message, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    continue block4;
                }
            }
        }
        return problemDescriptors.isEmpty() ? null : problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
    }
}

