/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesReferenceProvider;
import com.intellij.lang.properties.ResourceBundleReferenceProvider;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PropertiesReferenceContributor
extends PsiReferenceContributor {
    private static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider(){

        public boolean isSoft() {
            return true;
        }
    };

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression(), (PsiReferenceProvider)new PropertiesReferenceProvider(true));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().withParent((ElementPattern)PsiJavaPatterns.psiNameValuePair().withName("resourceBundle")), (PsiReferenceProvider)new ResourceBundleReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression(), new PsiReferenceProvider(){
            private final PsiReferenceProvider myUnderlying = new ResourceBundleReferenceProvider();

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiField)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiField field = (PsiField)parent;
                if (field.getInitializer() != element || !field.hasModifierProperty("final")) {
                    return PsiReference.EMPTY_ARRAY;
                }
                THashSet references = new THashSet(TObjectHashingStrategy.IDENTITY);
                for (PsiMethod method : PsiTreeUtil.findChildrenOfType((PsiElement)element.getContainingFile(), PsiMethod.class)) {
                    for (PsiParameter parameter : method.getParameterList().getParameters()) {
                        PsiAnnotation annotation;
                        PsiModifierList modifierList = parameter.getModifierList();
                        if (modifierList == null || (annotation = modifierList.findAnnotation("org.jetbrains.annotations.PropertyKey")) == null) continue;
                        for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                            PsiAnnotationMemberValue value;
                            if (!"resourceBundle".equals(pair.getName()) || !((value = pair.getValue()) instanceof PsiReferenceExpression) || ((PsiReferenceExpression)value).resolve() != field) continue;
                            Collections.addAll(references, this.myUnderlying.getReferencesByElement(element, context));
                        }
                    }
                }
                return references.toArray(new PsiReference[references.size()]);
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.psiElement(PropertyValueImpl.class), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                String text = element.getText();
                String[] words = text.split("\\s");
                if (words.length != 1) {
                    return PsiReference.EMPTY_ARRAY;
                }
                return CLASS_REFERENCE_PROVIDER.getReferencesByString(words[0], element, 0);
            }
        });
    }
}

