/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.model;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.ui.model.SpecialNode;
import com.intellij.execution.junit2.ui.model.TestProxyDescriptor;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.testframework.TestTreeViewStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import org.jetbrains.annotations.NotNull;

class TestTreeStructure
extends TestTreeViewStructure<TestProxy> {
    private final TestProxy myRootTest;
    private final JUnitConsoleProperties myProperties;
    private SpecialNode mySpecialNode;

    public TestTreeStructure(TestProxy rootTest, JUnitConsoleProperties properties) {
        this.myRootTest = rootTest;
        this.myProperties = properties;
    }

    public void setSpecialNode(SpecialNode specialNode) {
        this.mySpecialNode = specialNode;
    }

    public Object getRootElement() {
        return this.myRootTest;
    }

    public Object[] getChildElements(Object element) {
        TestProxy[] children = ((TestProxy)((Object)element)).selectChildren(this.getFilter());
        if (element == this.myRootTest) {
            if (children.length == 0 && this.myRootTest.getState().isPassed()) {
                this.mySpecialNode.setVisible(true);
                return this.mySpecialNode.asArray();
            }
            this.mySpecialNode.setVisible(false);
        }
        return children;
    }

    public Object getParentElement(Object element) {
        TestProxy testProxy = (TestProxy)((Object)element);
        return testProxy.getParent();
    }

    @NotNull
    public TestProxyDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        TestProxy testProxy = (TestProxy)((Object)element);
        return new TestProxyDescriptor(this.myProperties.getProject(), parentDescriptor, testProxy);
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }
}

