/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.javacvsImpl.ProjectContentInfoProvider;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.CvsRoot;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.admin.AdminWriter;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminWriter;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.IFileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.IReaderFactory;

public class AdminWriterOnCache
implements IAdminWriter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminWriterOnCache");
    private final IAdminWriter myAdminWriter;
    private final CvsEntriesManager myCvsEntriesManager = CvsEntriesManager.getInstance();
    private final UpdatedFilesManager myUpdatedFilesManager;
    private final ProjectContentInfoProvider myProjectContentInfoProvider;

    public AdminWriterOnCache(UpdatedFilesManager updatedFilesManager, ProjectContentInfoProvider projectContentInfoProvider) {
        this.myUpdatedFilesManager = updatedFilesManager;
        this.myProjectContentInfoProvider = projectContentInfoProvider;
        this.myAdminWriter = new AdminWriter(CodeStyleSettingsManager.getInstance().getCurrentSettings().getLineSeparator(), CvsApplicationLevelConfiguration.getCharset());
    }

    public void ensureCvsDirectory(DirectoryObject directoryObject, String repositoryPath, CvsRoot cvsRoot, ICvsFileSystem cvsFileSystem) throws IOException {
        if (this.notUnderCvs((AbstractFileObject)directoryObject, cvsFileSystem)) {
            return;
        }
        this.myAdminWriter.ensureCvsDirectory(directoryObject, repositoryPath, cvsRoot, cvsFileSystem);
        this.addDirectoryToParentEntriesFile(directoryObject, cvsFileSystem, cvsRoot.getCvsRoot());
    }

    private boolean notUnderCvs(AbstractFileObject directoryObject, ICvsFileSystem cvsFileSystem) {
        if (directoryObject == null) {
            return false;
        }
        File directory = cvsFileSystem.getLocalFileSystem().getFile(directoryObject);
        return !this.myProjectContentInfoProvider.fileIsUnderProject(directory);
    }

    private void addDirectoryToParentEntriesFile(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem, String cvsRoot) throws IOException {
        DirectoryObject parentDirectoryObject = directoryObject.getParent();
        if (parentDirectoryObject == null) {
            return;
        }
        File directory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        File parentDirectory = directory.getParentFile();
        if (parentDirectory == null) {
            return;
        }
        VirtualFile virtualParent = CvsVfsUtil.findFileByIoFile(parentDirectory);
        if (virtualParent == null) {
            return;
        }
        String directoryName = directory.getName();
        Entry entry = this.myCvsEntriesManager.getEntryFor(virtualParent, directoryName);
        if (entry == null && CvsUtil.fileIsUnderCvs(virtualParent) && CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(virtualParent).getCvsRootAsString().equals(cvsRoot)) {
            this.setEntry(parentDirectoryObject, Entry.createDirectoryEntry((String)directoryName), cvsFileSystem);
        }
    }

    public void setEntry(DirectoryObject directoryObject, Entry entry, ICvsFileSystem cvsFileSystem) throws IOException {
        File parent = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)directoryObject);
        if (this.myUpdatedFilesManager.fileIsNotUpdated(new File(parent, entry.getFileName()))) {
            return;
        }
        if (this.notUnderCvs((AbstractFileObject)directoryObject, cvsFileSystem)) {
            return;
        }
        this.myAdminWriter.setEntry(directoryObject, entry, cvsFileSystem);
        VirtualFile virtualParent = CvsVfsUtil.findFileByIoFile(parent);
        Entry existing = this.myCvsEntriesManager.getEntryFor(virtualParent, entry.getFileName());
        if (existing == null) {
            this.myUpdatedFilesManager.addNewlyCreatedEntry(entry);
        }
    }

    public void removeEntryForFile(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) throws IOException {
        if (this.notUnderCvs(fileObject, cvsFileSystem)) {
            return;
        }
        File file = cvsFileSystem.getLocalFileSystem().getFile(fileObject);
        if (this.myUpdatedFilesManager.fileIsNotUpdated(file)) {
            return;
        }
        this.myAdminWriter.removeEntryForFile(fileObject, cvsFileSystem);
    }

    public void pruneDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        LOG.error("Cannot be called");
    }

    public void editFile(FileObject fileObject, Entry entry, ICvsFileSystem cvsFileSystem, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        this.myAdminWriter.editFile(fileObject, entry, cvsFileSystem, fileReadOnlyHandler);
        File editBackupFile = AdminWriterOnCache.getEditBackupFile(fileObject, cvsFileSystem);
        File file = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)fileObject);
        editBackupFile.setLastModified(file.lastModified());
    }

    public void uneditFile(FileObject fileObject, ICvsFileSystem cvsFileSystem, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        File file = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)fileObject);
        File editBackupFile = AdminWriterOnCache.getEditBackupFile(fileObject, cvsFileSystem);
        if (!editBackupFile.isFile()) {
            return;
        }
        FileUtil.copy((File)editBackupFile, (File)file);
        file.setLastModified(editBackupFile.lastModified());
        this.myAdminWriter.uneditFile(fileObject, cvsFileSystem, fileReadOnlyHandler);
    }

    private static File getEditBackupFile(FileObject fileObject, ICvsFileSystem cvsFileSystem) {
        File file = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)fileObject);
        return new File(file.getParentFile(), "CVS" + File.separatorChar + "Base" + File.separatorChar + file.getName());
    }

    public void setStickyTagForDirectory(DirectoryObject directoryObject, String tag, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myAdminWriter.setStickyTagForDirectory(directoryObject, tag, cvsFileSystem);
        File ioDirectory = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)directoryObject);
        CvsEntriesManager.getInstance().getCvsInfoFor(CvsVfsUtil.findFileByIoFile(ioDirectory)).clearStickyInformation();
    }

    public void setEntriesDotStatic(DirectoryObject directoryObject, boolean set, ICvsFileSystem cvsFileSystem) throws IOException {
        this.myAdminWriter.setEntriesDotStatic(directoryObject, set, cvsFileSystem);
    }

    public void writeTemplateFile(@NotNull DirectoryObject directoryObject, int fileLength, InputStream inputStream, IReaderFactory readerFactory, IClientEnvironment clientEnvironment) throws IOException {
        this.myAdminWriter.writeTemplateFile(directoryObject, fileLength, inputStream, readerFactory, clientEnvironment);
    }

    public void directoryAdded(@NotNull DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) throws IOException {
        LOG.assertTrue(directoryObject.getParent() != null, (Object)directoryObject.getPath());
        File directory = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)directoryObject);
        if (!this.myProjectContentInfoProvider.fileIsUnderProject(directory)) {
            return;
        }
        this.myAdminWriter.directoryAdded(directoryObject, cvsFileSystem);
        File ioDirectory = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)directoryObject);
        CvsEntriesManager.getInstance().getCvsInfoFor(CvsVfsUtil.findFileByIoFile(ioDirectory)).clearAll();
    }
}

