/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.annotate;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.annotate.CvsFileAnnotation;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.AnnotateOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.Annotation;
import com.intellij.cvsSupport2.history.CvsHistoryProvider;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsAnnotationProvider
implements AnnotationProvider {
    @NonNls
    private static final String INVALID_OPTION_F = "invalid option -- F";
    @NonNls
    private static final String USAGE_CVSNTSRV_SERVER = "Usage: cvs";
    private static final Collection<String> ourDoNotAnnotateBinaryRoots = new HashSet<String>();
    private final Project myProject;
    private final CvsHistoryProvider myCvsHistoryProvider;

    public CvsAnnotationProvider(Project project, CvsHistoryProvider cvsHistoryProvider) {
        this.myProject = project;
        this.myCvsHistoryProvider = cvsHistoryProvider;
    }

    public FileAnnotation annotate(VirtualFile virtualFile) throws VcsException {
        File file = new File(virtualFile.getPath());
        File cvsLightweightFile = CvsUtil.getCvsLightweightFileForFile(file);
        String revision = CvsUtil.getRevisionFor(file);
        CvsEntriesManager entriesManager = CvsEntriesManager.getInstance();
        CvsConnectionSettings root = entriesManager.getCvsConnectionSettingsFor(file.getParentFile());
        boolean binary = CvsAnnotationProvider.annotateBinary(virtualFile, root);
        AnnotateOperation operation = this.executeOperation(cvsLightweightFile, revision, root, binary, true);
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(virtualFile);
        List<VcsFileRevision> revisions = this.myCvsHistoryProvider.createRevisions(filePath);
        Annotation[] lineAnnotations = operation.getLineAnnotations();
        CvsAnnotationProvider.adjustAnnotation(revisions, lineAnnotations);
        return new CvsFileAnnotation(operation.getContent(), lineAnnotations, revisions, virtualFile, revision, this.myProject);
    }

    public FileAnnotation annotate(VirtualFile file, VcsFileRevision revision) throws VcsException {
        CvsConnectionSettings settings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(file.getParent());
        return this.annotate(file, revision.getRevisionNumber().asString(), settings);
    }

    public boolean isAnnotationValid(VcsFileRevision rev) {
        return true;
    }

    public FileAnnotation annotate(VirtualFile cvsVirtualFile, String revision, CvsEnvironment environment) throws VcsException {
        ArrayList<VcsFileRevision> revisions;
        boolean hasLocalFile = false;
        File cvsFile = new File(cvsVirtualFile.getPath());
        if (cvsFile.isAbsolute()) {
            hasLocalFile = true;
            cvsFile = new File(CvsUtil.getModuleName(cvsVirtualFile));
        }
        boolean binary = CvsAnnotationProvider.annotateBinary(cvsVirtualFile, environment);
        AnnotateOperation annotateOperation = this.executeOperation(cvsFile, revision, environment, binary, true);
        Annotation[] lineAnnotations = annotateOperation.getLineAnnotations();
        if (hasLocalFile) {
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(cvsVirtualFile);
            revisions = this.myCvsHistoryProvider.createRevisions(filePath);
            CvsAnnotationProvider.adjustAnnotation(revisions, lineAnnotations);
        } else {
            revisions = new ArrayList();
            HashSet<String> usedRevisions = new HashSet<String>();
            for (Annotation annotation : lineAnnotations) {
                if (usedRevisions.contains(annotation.getRevision())) continue;
                revisions.add(new RevisionPresentation(annotation.getRevision(), annotation.getUserName(), annotation.getDate()));
                usedRevisions.add(annotation.getRevision());
            }
        }
        return new CvsFileAnnotation(annotateOperation.getContent(), lineAnnotations, revisions, cvsVirtualFile, revision, this.myProject);
    }

    private static boolean annotateBinary(VirtualFile cvsVirtualFile, CvsEnvironment environment) {
        if (ourDoNotAnnotateBinaryRoots.contains(environment.getCvsRootAsString())) {
            return false;
        }
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(cvsVirtualFile);
        if (entry != null) {
            return entry.isBinary();
        }
        return cvsVirtualFile.getFileType().isBinary();
    }

    private AnnotateOperation executeOperation(File file, String revision, CvsEnvironment root, boolean binary, boolean retryOnFailure) throws VcsException {
        AnnotateOperation operation = new AnnotateOperation(file, revision, root, binary);
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(new CommandCvsHandler(CvsBundle.getAnnotateOperationName(), operation), CvsOperationExecutorCallback.EMPTY);
        CvsResult result = executor.getResult();
        if (result.hasErrors()) {
            if (!retryOnFailure) {
                throw result.composeError();
            }
            for (VcsException error : result.getErrors()) {
                for (String message : error.getMessages()) {
                    if (!message.contains(INVALID_OPTION_F) && !message.contains(USAGE_CVSNTSRV_SERVER)) continue;
                    ourDoNotAnnotateBinaryRoots.add(root.getCvsRootAsString());
                    return this.executeOperation(file, revision, root, false, false);
                }
            }
            throw result.composeError();
        }
        return operation;
    }

    private static void adjustAnnotation(@Nullable List<VcsFileRevision> revisions, @NotNull Annotation[] lineAnnotations) {
        if (revisions != null) {
            HashMap<String, VcsFileRevision> revisionMap = new HashMap<String, VcsFileRevision>();
            for (VcsFileRevision vcsFileRevision : revisions) {
                revisionMap.put(vcsFileRevision.getRevisionNumber().asString(), vcsFileRevision);
            }
            for (Annotation lineAnnotation : lineAnnotations) {
                String revisionNumber = lineAnnotation.getRevision();
                VcsFileRevision revision = (VcsFileRevision)revisionMap.get(revisionNumber);
                if (revision == null) continue;
                lineAnnotation.setUser(revision.getAuthor());
                lineAnnotation.setDate(revision.getRevisionDate());
            }
        }
    }

    private static class RevisionPresentation
    implements VcsFileRevision {
        private final VcsRevisionNumber myNumber;
        private final String myAuthor;
        private final Date myDate;

        private RevisionPresentation(String revision, String author, Date date) {
            this.myNumber = new CvsRevisionNumber(revision);
            this.myAuthor = author;
            this.myDate = date;
        }

        public VcsRevisionNumber getRevisionNumber() {
            return this.myNumber;
        }

        public String getBranchName() {
            return null;
        }

        public Date getRevisionDate() {
            return this.myDate;
        }

        public String getAuthor() {
            return this.myAuthor;
        }

        public String getCommitMessage() {
            return null;
        }

        @Nullable
        public RepositoryLocation getChangedRepositoryPath() {
            return null;
        }

        public byte[] loadContent() throws IOException, VcsException {
            return this.getContent();
        }

        public byte[] getContent() throws IOException, VcsException {
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
    }
}

