/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.UpdateConfigurable;
import com.intellij.cvsSupport2.actions.merge.CvsMergeProvider;
import com.intellij.cvsSupport2.actions.update.UpdateSettingsOnCvsConfiguration;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.config.DateOrRevisionSettings;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsUpdatePolicy;
import com.intellij.cvsSupport2.cvshandlers.UpdateHandler;
import com.intellij.cvsSupport2.updateinfo.UpdatedFilesProcessor;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdateSessionAdapter;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CvsUpdateEnvironment
implements UpdateEnvironment {
    private final Project myProject;
    private boolean myLastUpdateWasConfigured = false;

    public CvsUpdateEnvironment(Project project) {
        this.myProject = project;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
        CvsUpdatePolicy.fillGroups(updatedFiles);
    }

    private static UpdateSettingsOnCvsConfiguration createSettingsAndUpdateContext(CvsConfiguration cvsConfiguration, @NotNull Ref<SequentialUpdatesContext> contextRef) {
        if (contextRef.get() != null) {
            CvsSequentialUpdateContext cvsContext = (CvsSequentialUpdateContext)contextRef.get();
            contextRef.set(null);
            return cvsContext.getConfiguration();
        }
        if (!cvsConfiguration.CLEAN_COPY && cvsConfiguration.UPDATE_DATE_OR_REVISION_SETTINGS.overridesDefault() && cvsConfiguration.MERGING_MODE != 0) {
            UpdateSettingsOnCvsConfiguration secondUpdate = new UpdateSettingsOnCvsConfiguration(cvsConfiguration.PRUNE_EMPTY_DIRECTORIES, cvsConfiguration.MERGING_MODE, cvsConfiguration.MERGE_WITH_BRANCH1_NAME, cvsConfiguration.MERGE_WITH_BRANCH2_NAME, cvsConfiguration.CREATE_NEW_DIRECTORIES, cvsConfiguration.UPDATE_KEYWORD_SUBSTITUTION, new DateOrRevisionSettings(), cvsConfiguration.MAKE_NEW_FILES_READONLY, cvsConfiguration.CLEAN_COPY, cvsConfiguration.RESET_STICKY);
            contextRef.set((Object)new CvsSequentialUpdateContext(secondUpdate, cvsConfiguration.UPDATE_DATE_OR_REVISION_SETTINGS.asString()));
            return new UpdateSettingsOnCvsConfiguration(cvsConfiguration.PRUNE_EMPTY_DIRECTORIES, 0, null, null, cvsConfiguration.CREATE_NEW_DIRECTORIES, cvsConfiguration.UPDATE_KEYWORD_SUBSTITUTION, cvsConfiguration.UPDATE_DATE_OR_REVISION_SETTINGS, cvsConfiguration.MAKE_NEW_FILES_READONLY, cvsConfiguration.CLEAN_COPY, cvsConfiguration.RESET_STICKY);
        }
        return new UpdateSettingsOnCvsConfiguration(cvsConfiguration, cvsConfiguration.CLEAN_COPY, cvsConfiguration.RESET_STICKY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> contextRef) {
        CvsConfiguration cvsConfiguration = CvsConfiguration.getInstance(this.myProject);
        if (!this.myLastUpdateWasConfigured) {
            cvsConfiguration.CLEAN_COPY = false;
            cvsConfiguration.RESET_STICKY = false;
        }
        this.myLastUpdateWasConfigured = false;
        try {
            UpdateSettingsOnCvsConfiguration updateSettings = CvsUpdateEnvironment.createSettingsAndUpdateContext(cvsConfiguration, contextRef);
            UpdateHandler handler = CommandCvsHandler.createUpdateHandler(contentRoots, updateSettings, this.myProject, updatedFiles);
            handler.addCvsListener(new UpdatedFilesProcessor(updatedFiles));
            CvsOperationExecutor cvsOperationExecutor = new CvsOperationExecutor(true, this.myProject, ModalityState.defaultModalityState());
            cvsOperationExecutor.setShowErrors(false);
            cvsOperationExecutor.performActionSync(handler, CvsOperationExecutorCallback.EMPTY);
            CvsResult result = cvsOperationExecutor.getResult();
            UpdateSessionAdapter updateSessionAdapter = this.createUpdateSessionAdapter(updatedFiles, result);
            return updateSessionAdapter;
        }
        finally {
            cvsConfiguration.CLEAN_COPY = false;
            cvsConfiguration.RESET_STICKY = false;
        }
    }

    private UpdateSessionAdapter createUpdateSessionAdapter(final UpdatedFiles updatedFiles, CvsResult result) {
        return new UpdateSessionAdapter(result.getErrorsAndWarnings(), result.isCanceled()){

            public void onRefreshFilesCompleted() {
                FileGroup mergedWithConflictsGroup = updatedFiles.getGroupById("MERGED_WITH_CONFLICTS");
                FileGroup binaryMergedGroup = updatedFiles.getGroupById("BINARY_MERGED");
                if (!mergedWithConflictsGroup.isEmpty() || !binaryMergedGroup.isEmpty()) {
                    ArrayList paths = new ArrayList();
                    paths.addAll(mergedWithConflictsGroup.getFiles());
                    paths.addAll(binaryMergedGroup.getFiles());
                    List list = CvsUpdateEnvironment.invokeManualMerging(paths, CvsUpdateEnvironment.this.myProject);
                    FileGroup mergedGroup = updatedFiles.getGroupById("MERGED");
                    VcsKey vcsKey = CvsVcs2.getKey();
                    for (VirtualFile mergedFile : list) {
                        String path = FileUtil.toSystemDependentName((String)mergedFile.getPresentableUrl());
                        mergedWithConflictsGroup.remove(path);
                        binaryMergedGroup.remove(path);
                        mergedGroup.add(path, vcsKey, null);
                    }
                }
            }
        };
    }

    private static List<VirtualFile> invokeManualMerging(Collection<String> paths, Project project) {
        final ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String path : paths) {
            VirtualFile virtualFile = CvsVfsUtil.findFileByIoFile(new File(path));
            if (virtualFile == null) continue;
            files.add(virtualFile);
            if (virtualFile.isWritable()) continue;
            readOnlyFiles.add(virtualFile);
        }
        if (readOnlyFiles.size() > 0) {
            CvsHandler editHandler = CommandCvsHandler.createEditHandler(VfsUtil.toVirtualFileArray(readOnlyFiles), CvsConfiguration.getInstance((Project)project).RESERVED_EDIT);
            new CvsOperationExecutor(true, project, ModalityState.current()).performActionSync(editHandler, CvsOperationExecutorCallback.EMPTY);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : readOnlyFiles) {
                        file.refresh(false, false);
                    }
                }
            });
        }
        if (!files.isEmpty()) {
            return AbstractVcsHelper.getInstance((Project)project).showMergeDialog(files, (MergeProvider)new CvsMergeProvider());
        }
        return Collections.emptyList();
    }

    public Configurable createConfigurable(Collection<FilePath> files) {
        this.myLastUpdateWasConfigured = true;
        CvsConfiguration.getInstance((Project)this.myProject).CLEAN_COPY = false;
        CvsConfiguration.getInstance((Project)this.myProject).RESET_STICKY = false;
        return new UpdateConfigurable(this.myProject, files);
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    private static class CvsSequentialUpdateContext
    implements SequentialUpdatesContext {
        private final UpdateSettingsOnCvsConfiguration myConfiguration;
        private final String myUpdateTagName;

        private CvsSequentialUpdateContext(UpdateSettingsOnCvsConfiguration configuration, String tagName) {
            this.myUpdateTagName = tagName;
            this.myConfiguration = configuration;
        }

        @NotNull
        public String getMessageWhenInterruptedBeforeStart() {
            String mergeString = "-j " + this.myConfiguration.getBranch1ToMergeWith();
            if (this.myConfiguration.getBranch2ToMergeWith() != null) {
                mergeString = mergeString + " -j " + this.myConfiguration.getBranch2ToMergeWith();
            }
            return "Merge (" + mergeString + ") wasn't started, only update (-r " + this.myUpdateTagName + ") was performed";
        }

        public boolean shouldFail() {
            return true;
        }

        public UpdateSettingsOnCvsConfiguration getConfiguration() {
            return this.myConfiguration;
        }
    }
}

