/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.remote.internal.packages;

import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.legacy.descriptors.PkgDesc;
import com.android.sdklib.repository.legacy.local.LocalAddonPkgInfo;
import com.android.sdklib.repository.legacy.remote.RemotePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.LayoutlibVersionMixin;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemotePackageParserUtils;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.w3c.dom.Node;

@Deprecated
public class RemoteAddonPkgInfo
extends RemotePkgInfo {
    private final LayoutlibVersionMixin mLayoutlibVersion;
    private final Lib[] mLibs;

    public RemoteAddonPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        String nameId = RemotePackageParserUtils.getXmlString(packageNode, "name-id").trim();
        String nameDisp = RemotePackageParserUtils.getXmlString(packageNode, "name-display").trim();
        String name = RemotePackageParserUtils.getXmlString(packageNode, "name").trim();
        if (nameDisp.length() == 0) {
            nameDisp = name;
        }
        if (nameId.length() == 0) {
            nameId = LocalAddonPkgInfo.sanitizeDisplayToNameId(name.length() > 0 ? name : nameDisp);
        }
        assert (nameId.length() > 0);
        assert (nameDisp.length() > 0);
        String vendorId = RemotePackageParserUtils.getXmlString(packageNode, "vendor-id").trim();
        String vendorDisp = RemotePackageParserUtils.getXmlString(packageNode, "vendor-display").trim();
        String vendor = RemotePackageParserUtils.getXmlString(packageNode, "vendor").trim();
        if (vendorDisp.length() == 0) {
            vendorDisp = vendor;
        }
        if (vendorId.length() == 0) {
            boolean hasVendor = vendor.length() > 0;
            vendorId = LocalAddonPkgInfo.sanitizeDisplayToNameId(hasVendor ? vendor : vendorDisp);
        }
        assert (vendorId.length() > 0);
        assert (vendorDisp.length() > 0);
        int apiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        AndroidVersion androidVersion = new AndroidVersion(apiLevel, null);
        this.mLibs = this.parseLibs(RemotePackageParserUtils.findChildElement(packageNode, "libs"));
        this.mLayoutlibVersion = new LayoutlibVersionMixin(packageNode);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newAddon(androidVersion, this.getRevision(), IdDisplay.create(vendorId, vendorDisp), IdDisplay.create(nameId, nameDisp));
        pkgDescBuilder.setDescriptionShort(RemoteAddonPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), nameDisp, androidVersion, this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteAddonPkgInfo.createListDescription(this.mListDisplay, nameDisp, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    private Lib[] parseLibs(Node libsNode) {
        ArrayList<Lib> libs = new ArrayList<Lib>();
        if (libsNode != null) {
            String nsUri = libsNode.getNamespaceURI();
            for (Node child = libsNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"lib".equals(child.getLocalName())) continue;
                libs.add(this.parseLib(child));
            }
        }
        return libs.toArray(new Lib[libs.size()]);
    }

    private Lib parseLib(Node libNode) {
        return new Lib(RemotePackageParserUtils.getXmlString(libNode, "name"), RemotePackageParserUtils.getXmlString(libNode, "description"));
    }

    public Lib[] getLibs() {
        return this.mLibs;
    }

    private static String createListDescription(String listDisplay, String displayName, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        return String.format("%1$s%2$s", displayName, obsolete ? " (Obsolete)" : "");
    }

    private static String createShortDescription(String listDisplay, Revision revision, String displayName, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        return String.format("%1$s, Android API %2$s, revision %3$s%4$s", displayName, version.getApiString(), revision.toShortString(), obsolete ? " (Obsolete)" : "");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        result = 31 * result + Arrays.hashCode(this.mLibs);
        String name = this.getPkgDesc().getName().getDisplay();
        result = 31 * result + (name == null ? 0 : name.hashCode());
        result = 31 * result + (this.getPkgDesc().hasVendor() ? 0 : this.getPkgDesc().getVendor().hashCode());
        result = 31 * result + this.getPkgDesc().getAndroidVersion().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RemoteAddonPkgInfo)) {
            return false;
        }
        RemoteAddonPkgInfo other = (RemoteAddonPkgInfo)obj;
        if (this.mLayoutlibVersion == null ? other.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(other.mLayoutlibVersion)) {
            return false;
        }
        return Arrays.equals(this.mLibs, other.mLibs);
    }

    public static class Lib {
        private final String mName;
        private final String mDescription;

        public Lib(String name, String description) {
            this.mName = name;
            this.mDescription = description;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mDescription == null ? 0 : this.mDescription.hashCode());
            result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Lib)) {
                return false;
            }
            Lib other = (Lib)obj;
            if (this.mDescription == null ? other.mDescription != null : !this.mDescription.equals(other.mDescription)) {
                return false;
            }
            return !(this.mName == null ? other.mName != null : !this.mName.equals(other.mName));
        }
    }
}

