/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

public enum Abi {
    ARMEABI("armeabi", "ARM", "arm"),
    ARMEABI_V7A("armeabi-v7a", "ARM", "arm", "cortex-a8"),
    ARM64_V8A("arm64-v8a", "ARM", "arm64"),
    X86("x86", "Intel Atom", "x86"),
    X86_64("x86_64", "Intel Atom", "x86_64"),
    MIPS("mips", "MIPS", "mips"),
    MIPS64("mips64", "MIPS", "mips64");

    private final String mAbi;
    private final String mCpuArch;
    private final String mCpuModel;
    private final String mDisplayName;

    private Abi(String abi, String displayName, String cpuArch) {
        this(abi, displayName, cpuArch, null);
    }

    private Abi(String abi, String displayName, String cpuArch, String cpuModel) {
        this.mAbi = abi;
        this.mDisplayName = displayName;
        this.mCpuArch = cpuArch;
        this.mCpuModel = cpuModel;
    }

    public static Abi getEnum(String abi) {
        for (Abi a : Abi.values()) {
            if (!a.mAbi.equals(abi)) continue;
            return a;
        }
        return null;
    }

    public String toString() {
        return this.mAbi;
    }

    public String getCpuArch() {
        return this.mCpuArch;
    }

    public String getCpuModel() {
        return this.mCpuModel;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }
}

