/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import com.android.build.api.transform.Transform;
import com.android.tools.profiler.ProfilerTransform;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;

public class ProfilerPlugin
implements Plugin<Project> {
    private static final String PROPERTY_PROPERTIES_FILE = "android.profiler.properties";
    private static final String PROPERTY_ENABLED = "android.profiler.enabled";
    private static final String PROPERTY_GAPID_ENABLED = "android.profiler.gapid.enabled";
    private static final String PROPERTY_GAPID_TRACER_AAR = "android.profiler.gapid.tracer_aar";
    private static final String PROPERTY_SUPPORT_LIB_ENABLED = "android.profiler.supportLib.enabled";
    private static final String PROPERTY_INSTRUMENTATION_ENABLED = "android.profiler.instrumentation.enabled";

    public void apply(Project project) {
        Properties properties = this.getProperties(project);
        boolean enabled = ProfilerPlugin.getBoolean(properties, PROPERTY_ENABLED);
        if (enabled) {
            this.addProfilersLib(project, properties);
            this.applyGapidOptions(project, properties);
            this.registerTransform(project, properties);
        }
    }

    private void addProfilersLib(Project project, Properties properties) {
        if (ProfilerPlugin.getBoolean(properties, PROPERTY_SUPPORT_LIB_ENABLED)) {
            if (!this.isApplicationProject(project)) {
                return;
            }
            project.getDependencies().add("compile", (Object)"com.android.tools:studio-profiler-lib:1.0");
        }
    }

    private void applyGapidOptions(Project project, Properties properties) {
        if (ProfilerPlugin.getBoolean(properties, PROPERTY_GAPID_ENABLED)) {
            File aarFile;
            String aarFileName = properties.getProperty(PROPERTY_GAPID_TRACER_AAR);
            File file = aarFile = aarFileName == null ? null : new File(aarFileName);
            if (aarFile != null && aarFile.exists()) {
                RepositoryHandler repositories = project.getRepositories();
                repositories.add((ArtifactRepository)repositories.flatDir((Map)new HashMap<String, Object>(){
                    {
                        this.put("name", "gfxtracer");
                        this.put("dirs", Arrays.asList(aarFile.getParentFile().getAbsolutePath()));
                    }
                }));
                final String baseName = Files.getNameWithoutExtension((String)aarFileName);
                final String extension = Files.getFileExtension((String)aarFileName);
                project.getDependencies().add("compile", (Object)new HashMap<String, String>(){
                    {
                        this.put("name", baseName);
                        this.put("ext", extension);
                    }
                });
            }
        }
    }

    private void registerTransform(Project project, Properties properties) {
        if (ProfilerPlugin.getBoolean(properties, PROPERTY_INSTRUMENTATION_ENABLED)) {
            if (!this.isApplicationProject(project)) {
                return;
            }
            try {
                Object android = project.getExtensions().getByName("android");
                Method registerTransform = android.getClass().getMethod("registerTransform", Transform.class, Object[].class);
                registerTransform.invoke(android, new Object[]{new ProfilerTransform(), new Object[0]});
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isApplicationProject(Project project) {
        Object android = project.getExtensions().getByName("android");
        try {
            android.getClass().getMethod("getApplicationVariants", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties getProperties(Project project) {
        Map projectProperties = project.getProperties();
        Properties defaults = new Properties();
        for (Map.Entry e : projectProperties.entrySet()) {
            if (e.getValue() == null) continue;
            defaults.put(e.getKey(), e.getValue());
        }
        Properties result = new Properties(defaults);
        Object propertiesFile = projectProperties.get(PROPERTY_PROPERTIES_FILE);
        if (propertiesFile == null) return result;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(String.valueOf(propertiesFile)), Charsets.UTF_8);
            result.load(reader);
            if (reader == null) return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return result;
        }
        finally {
            if (reader != null) {
                Closeables.closeQuietly(reader);
            }
        }
        Closeables.closeQuietly((Reader)reader);
        return result;
    }

    private static boolean getBoolean(Properties properties, String name) {
        return Boolean.parseBoolean(properties.getProperty(name, "false"));
    }
}

