/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

final class NetworkingAdapter
extends ClassVisitor
implements Opcodes {
    static final String URL_CLASS = "java/net/URL";
    static final String WRAPPER_CLASS = "com/android/tools/profiler/support/network/HttpWrapper";

    NetworkingAdapter(ClassVisitor classVisitor) {
        super(327680, classVisitor);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return mv != null ? new MethodAdapter(mv) : null;
    }

    private static final class MethodAdapter
    extends MethodVisitor
    implements Opcodes {
        public MethodAdapter(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode != 182 || !owner.equals(NetworkingAdapter.URL_CLASS)) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                return;
            }
            assert (!itf);
            if (name.equals("openConnection") && desc.equals("()Ljava/net/URLConnection;")) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.invoke("wrapURLConnection", "(Ljava/net/URLConnection;)Ljava/net/URLConnection;");
            } else if (name.equals("openConnection") && desc.equals("(Ljava/net/Proxy;)Ljava/net/URLConnection;")) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.invoke("wrapURLConnection", "(Ljava/net/URLConnection;)Ljava/net/URLConnection;");
            } else if (name.equals("openStream") && desc.equals("()Ljava/io/InputStream;")) {
                this.invoke("wrapOpenStream", "(Ljava/net/URL;)Ljava/io/InputStream;");
            } else if (name.equals("getContent") && desc.equals("()Ljava/lang/Object;")) {
                this.invoke("wrapGetContent", "(Ljava/net/URL;)Ljava/lang/Object;");
            } else if (name.equals("getContent") && desc.equals("([Ljava/lang/Class;)Ljava/lang/Object;")) {
                this.invoke("wrapGetContent", "(Ljava/net/URL;[Ljava/lang/Class;)Ljava/lang/Object;");
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        private void invoke(String method, String desc) {
            super.visitMethodInsn(184, NetworkingAdapter.WRAPPER_CLASS, method, desc, false);
        }
    }
}

