/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public final class FileUtils {
    private FileUtils() {
    }

    public static void mkdirs(File folder) {
        if (!folder.mkdirs() && !folder.exists()) {
            throw new RuntimeException("Cannot create directory " + folder);
        }
    }

    public static void delete(File file) throws IOException {
        boolean result = file.delete();
        if (!result) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static String relativePath(File file, File dir) {
        Preconditions.checkArgument((file.isFile() || file.isDirectory() ? 1 : 0) != 0, (String)"%s is not a file nor a directory.", (Object[])new Object[]{file.getPath()});
        Preconditions.checkArgument((boolean)dir.isDirectory(), (String)"%s is not a directory.", (Object[])new Object[]{dir.getPath()});
        return FileUtils.relativePossiblyNonExistingPath(file, dir);
    }

    public static String relativePossiblyNonExistingPath(File file, File dir) {
        String path = dir.toURI().relativize(file.toURI()).getPath();
        return FileUtils.toSystemDependentPath(path);
    }

    public static String toSystemDependentPath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return path;
    }

    public static FluentIterable<File> getAllFiles(File dir) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)dir).filter(Files.isFile());
    }
}

