/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.tools.profiler.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

abstract class ClassTransform
extends Transform {
    private final String mName;

    public ClassTransform(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.SUB_PROJECTS, (Object)QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, (Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.PROJECT_LOCAL_DEPS);
    }

    public boolean isIncremental() {
        return true;
    }

    private String formatOutputName(int number, String name) {
        return String.format("%d_%s", number, name);
    }

    public void transform(TransformInvocation invocation) throws InterruptedException, IOException {
        assert (invocation.getOutputProvider() != null);
        int outputNumber = 0;
        for (TransformInput ti : invocation.getInputs()) {
            String name;
            for (JarInput jarInput : ti.getJarInputs()) {
                File inputJar = jarInput.getFile();
                name = this.formatOutputName(outputNumber++, Files.getNameWithoutExtension((String)inputJar.getName()));
                File outputJar = invocation.getOutputProvider().getContentLocation(name, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                if (invocation.isIncremental()) {
                    switch (jarInput.getStatus()) {
                        case NOTCHANGED: {
                            break;
                        }
                        case ADDED: 
                        case CHANGED: {
                            this.transformJar(inputJar, outputJar);
                            break;
                        }
                        case REMOVED: {
                            FileUtils.delete(outputJar);
                        }
                    }
                    continue;
                }
                this.transformJar(inputJar, outputJar);
            }
            for (DirectoryInput di : ti.getDirectoryInputs()) {
                File inputDir = di.getFile();
                name = this.formatOutputName(outputNumber++, inputDir.getName());
                File outputDir = invocation.getOutputProvider().getContentLocation(name, di.getContentTypes(), di.getScopes(), Format.DIRECTORY);
                if (invocation.isIncremental()) {
                    block13: for (Map.Entry entry : di.getChangedFiles().entrySet()) {
                        File inputFile = (File)entry.getKey();
                        switch ((Status)entry.getValue()) {
                            case NOTCHANGED: {
                                break;
                            }
                            case ADDED: 
                            case CHANGED: {
                                for (File in : FileUtils.getAllFiles(inputFile)) {
                                    File out = ClassTransform.toOutputFile(outputDir, inputDir, in);
                                    this.transformFile(in, out);
                                }
                                continue block13;
                            }
                            case REMOVED: {
                                File outputFile = ClassTransform.toOutputFile(outputDir, inputDir, inputFile);
                                FileUtils.delete(outputFile);
                            }
                        }
                    }
                    continue;
                }
                for (File in : FileUtils.getAllFiles(inputDir)) {
                    File out = ClassTransform.toOutputFile(outputDir, inputDir, in);
                    this.transformFile(in, out);
                }
            }
        }
    }

    private void transformJar(File inputJar, File outputJar) throws IOException {
        Files.createParentDirs((File)outputJar);
        try (FileInputStream fis = new FileInputStream(inputJar);
             ZipInputStream zis = new ZipInputStream(fis);
             FileOutputStream fos = new FileOutputStream(outputJar);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                zos.putNextEntry(new ZipEntry(entry.getName()));
                if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                    this.transform(zis, zos);
                } else {
                    ByteStreams.copy((InputStream)zis, (OutputStream)zos);
                }
                entry = zis.getNextEntry();
            }
        }
    }

    private void transformFile(File inputFile, File outputFile) throws IOException {
        Files.createParentDirs((File)outputFile);
        try (FileInputStream fis = new FileInputStream(inputFile);
             FileOutputStream fos = new FileOutputStream(outputFile);){
            this.transform(fis, fos);
        }
    }

    private static File toOutputFile(File outputDir, File inputDir, File inputFile) {
        return new File(outputDir, FileUtils.relativePath(inputFile, inputDir));
    }

    protected abstract void transform(InputStream var1, OutputStream var2) throws IOException;
}

