/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LittleEndianUtils {
    private LittleEndianUtils() {
    }

    public static long readUnsigned4Le(ByteBuffer bytes) throws IOException {
        byte b3;
        byte b2;
        byte b1;
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes == null");
        if (bytes.remaining() < 4) {
            throw new EOFException("Not enough data: 4 bytes expected, " + bytes.remaining() + " available.");
        }
        byte b0 = bytes.get();
        long r = (long)(b0 & 0xFF | ((b1 = bytes.get()) & 0xFF) << 8 | ((b2 = bytes.get()) & 0xFF) << 16) | ((long)(b3 = bytes.get()) & 0xFFL) << 24;
        Verify.verify((r >= 0L ? 1 : 0) != 0);
        Verify.verify((r <= 0xFFFFFFFFL ? 1 : 0) != 0);
        return r;
    }

    public static int readUnsigned2Le(ByteBuffer bytes) throws IOException {
        byte b1;
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes == null");
        if (bytes.remaining() < 2) {
            throw new EOFException("Not enough data: 2 bytes expected, " + bytes.remaining() + " available.");
        }
        byte b0 = bytes.get();
        int r = b0 & 0xFF | ((b1 = bytes.get()) & 0xFF) << 8;
        Verify.verify((r >= 0 ? 1 : 0) != 0);
        Verify.verify((r <= 65535 ? 1 : 0) != 0);
        return r;
    }

    public static void writeUnsigned4Le(ByteBuffer output, long value) throws IOException {
        Preconditions.checkNotNull((Object)output, (Object)"output == null");
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value (%s) < 0", (Object[])new Object[]{value});
        Preconditions.checkArgument((value <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"value (%s) > 0x00000000ffffffffL", (Object[])new Object[]{value});
        output.put((byte)(value & 0xFFL));
        output.put((byte)(value >> 8 & 0xFFL));
        output.put((byte)(value >> 16 & 0xFFL));
        output.put((byte)(value >> 24 & 0xFFL));
    }

    public static void writeUnsigned2Le(ByteBuffer output, int value) throws IOException {
        Preconditions.checkNotNull((Object)output, (Object)"output == null");
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (String)"value (%s) < 0", (Object[])new Object[]{value});
        Preconditions.checkArgument((value <= 65535 ? 1 : 0) != 0, (String)"value (%s) > 0x0000ffff", (Object[])new Object[]{value});
        output.put((byte)(value & 0xFF));
        output.put((byte)(value >> 8 & 0xFF));
    }
}

