/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.CentralDirectoryHeaderCompressInfo;
import com.android.builder.internal.packaging.zip.EncodeUtils;
import com.android.builder.internal.packaging.zip.GPFlags;
import com.android.builder.internal.packaging.zip.utils.MsDosDateTimeUtils;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class CentralDirectoryHeader
implements Cloneable {
    private static final int DEFAULT_VERSION_MADE_BY = 24;
    private String mName;
    private long mCrc32;
    private long mUncompressedSize;
    private long mMadeBy;
    private GPFlags mGpBit;
    private long mLastModTime;
    private long mLastModDate;
    private byte[] mExtraField;
    private byte[] mComment;
    private long mInternalAttributes;
    private long mExternalAttributes;
    private long mOffset;
    private byte[] mEncodedFileName;
    private Future<CentralDirectoryHeaderCompressInfo> mCompressInfo;

    CentralDirectoryHeader(String name, long uncompressedSize, Future<CentralDirectoryHeaderCompressInfo> compressInfo, GPFlags flags) {
        this.mName = name;
        this.mUncompressedSize = uncompressedSize;
        this.mCrc32 = 0L;
        this.mMadeBy = 24L;
        this.mGpBit = flags;
        this.mLastModTime = MsDosDateTimeUtils.packCurrentTime();
        this.mLastModDate = MsDosDateTimeUtils.packCurrentDate();
        this.mExtraField = new byte[0];
        this.mComment = new byte[0];
        this.mInternalAttributes = 0L;
        this.mExternalAttributes = 0L;
        this.mOffset = -1L;
        this.mEncodedFileName = EncodeUtils.encode(name, this.mGpBit);
        this.mCompressInfo = compressInfo;
    }

    public String getName() {
        return this.mName;
    }

    public long getUncompressedSize() {
        return this.mUncompressedSize;
    }

    public long getCrc32() {
        return this.mCrc32;
    }

    public void setCrc32(long crc32) {
        this.mCrc32 = crc32;
    }

    public long getMadeBy() {
        return this.mMadeBy;
    }

    public void setMadeBy(long madeBy) {
        this.mMadeBy = madeBy;
    }

    public GPFlags getGpBit() {
        return this.mGpBit;
    }

    public long getLastModTime() {
        return this.mLastModTime;
    }

    public void setLastModTime(long lastModTime) {
        this.mLastModTime = lastModTime;
    }

    public long getLastModDate() {
        return this.mLastModDate;
    }

    public void setLastModDate(long lastModDate) {
        this.mLastModDate = lastModDate;
    }

    public byte[] getExtraField() {
        return this.mExtraField;
    }

    public void setExtraField(byte[] extraField) {
        this.mExtraField = extraField;
    }

    public byte[] getComment() {
        return this.mComment;
    }

    public void setComment(byte[] comment) {
        this.mComment = comment;
    }

    public long getInternalAttributes() {
        return this.mInternalAttributes;
    }

    public void setInternalAttributes(long internalAttributes) {
        this.mInternalAttributes = internalAttributes;
    }

    public long getExternalAttributes() {
        return this.mExternalAttributes;
    }

    public void setExternalAttributes(long externalAttributes) {
        this.mExternalAttributes = externalAttributes;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public void setOffset(long offset) {
        this.mOffset = offset;
    }

    public byte[] getEncodedFileName() {
        return this.mEncodedFileName;
    }

    public void resetDeferredCrc() {
        this.mGpBit = GPFlags.make(this.mGpBit.isUtf8FileName());
    }

    protected CentralDirectoryHeader clone() throws CloneNotSupportedException {
        CentralDirectoryHeader cdr = (CentralDirectoryHeader)super.clone();
        cdr.mExtraField = Arrays.copyOf(this.mExtraField, this.mExtraField.length);
        cdr.mComment = Arrays.copyOf(this.mComment, this.mComment.length);
        cdr.mEncodedFileName = Arrays.copyOf(this.mEncodedFileName, this.mEncodedFileName.length);
        return cdr;
    }

    public Future<CentralDirectoryHeaderCompressInfo> getCompressionInfo() {
        return this.mCompressInfo;
    }

    public CentralDirectoryHeaderCompressInfo getCompressionInfoWithWait() throws IOException {
        try {
            CentralDirectoryHeaderCompressInfo info = this.getCompressionInfo().get();
            Verify.verifyNotNull((Object)info, (String)"info == null", (Object[])new Object[0]);
            return info;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for compression information.", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Execution of compression failed.", e);
        }
    }
}

