/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.sign.v2;

import com.android.builder.internal.packaging.sign.v2.ContentDigestAlgorithm;
import com.android.utils.Pair;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public enum SignatureAlgorithm {
    RSA_PSS_WITH_SHA256(257, ContentDigestAlgorithm.CHUNKED_SHA256, (Pair<String, ? extends AlgorithmParameterSpec>)Pair.of((Object)"SHA256withRSA/PSS", (Object)new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1))),
    RSA_PSS_WITH_SHA512(258, ContentDigestAlgorithm.CHUNKED_SHA512, (Pair<String, ? extends AlgorithmParameterSpec>)Pair.of((Object)"SHA512withRSA/PSS", (Object)new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1))),
    RSA_PKCS1_V1_5_WITH_SHA256(259, ContentDigestAlgorithm.CHUNKED_SHA256, (Pair<String, ? extends AlgorithmParameterSpec>)Pair.of((Object)"SHA256withRSA", null)),
    RSA_PKCS1_V1_5_WITH_SHA512(260, ContentDigestAlgorithm.CHUNKED_SHA512, (Pair<String, ? extends AlgorithmParameterSpec>)Pair.of((Object)"SHA512withRSA", null)),
    ECDSA_WITH_SHA256(513, ContentDigestAlgorithm.CHUNKED_SHA256, (Pair<String, ? extends AlgorithmParameterSpec>)Pair.of((Object)"SHA256withECDSA", null)),
    ECDSA_WITH_SHA512(514, ContentDigestAlgorithm.CHUNKED_SHA512, (Pair<String, ? extends AlgorithmParameterSpec>)Pair.of((Object)"SHA512withECDSA", null)),
    DSA_WITH_SHA256(769, ContentDigestAlgorithm.CHUNKED_SHA256, (Pair<String, ? extends AlgorithmParameterSpec>)Pair.of((Object)"SHA256withDSA", null));

    private final int mId;
    private final ContentDigestAlgorithm mContentDigestAlgorithm;
    private final Pair<String, ? extends AlgorithmParameterSpec> mJcaSignatureAlgAndParams;

    private SignatureAlgorithm(int id, ContentDigestAlgorithm contentDigestAlgorithm, Pair<String, ? extends AlgorithmParameterSpec> jcaSignatureAlgAndParams) {
        this.mId = id;
        this.mContentDigestAlgorithm = contentDigestAlgorithm;
        this.mJcaSignatureAlgAndParams = jcaSignatureAlgAndParams;
    }

    int getId() {
        return this.mId;
    }

    ContentDigestAlgorithm getContentDigestAlgorithm() {
        return this.mContentDigestAlgorithm;
    }

    Pair<String, ? extends AlgorithmParameterSpec> getJcaSignatureAlgorithmAndParams() {
        return this.mJcaSignatureAlgAndParams;
    }
}

