/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.builder.internal.aapt.AbstractProcessExecutionAapt;
import com.android.builder.internal.aapt.v2.Aapt2RenamingConventions;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OutOfProcessAaptV2
extends AbstractProcessExecutionAapt {
    private static final Revision VERSION_FOR_SERVER_AAPT = new Revision(22, 0, 0);
    private final BuildToolInfo mBuildToolInfo;
    private final File mIntermediateDir;

    public OutOfProcessAaptV2(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, BuildToolInfo buildToolInfo, File intermediateDir, ILogger logger) {
        super(processExecutor, processOutputHandler);
        Preconditions.checkArgument((boolean)intermediateDir.isDirectory(), (Object)"!intermediateDir.isDirectory()");
        this.mBuildToolInfo = buildToolInfo;
        this.mIntermediateDir = intermediateDir;
    }

    @Override
    protected AbstractProcessExecutionAapt.CompileInvocation makeCompileProcessBuilder(File file, File output) throws AaptException {
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)output.isDirectory(), (Object)"!output.isDirectory()");
        return new AbstractProcessExecutionAapt.CompileInvocation(new ProcessInfoBuilder().setExecutable(this.getAapt2ExecutablePath()).addArgs("compile").addArgs("-o").addArgs(output.getAbsolutePath()).addArgs(file.getAbsolutePath()), new File(output, Aapt2RenamingConventions.compilationRename(file)));
    }

    @Override
    protected ProcessInfoBuilder makePackageProcessBuilder(AaptPackageConfig config) throws AaptException {
        List additionalParameters;
        Collection noCompressList;
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getAapt2ExecutablePath());
        builder.addArgs("link");
        if (config.isVerbose()) {
            builder.addArgs("-v");
        }
        File stableResourceIdsFile = new File(this.mIntermediateDir, "stable-resource-ids.txt");
        IAndroidTarget target = config.getAndroidTarget();
        Preconditions.checkNotNull((Object)target);
        builder.addArgs("-I", target.getPath(1));
        File manifestFile = config.getManifestFile();
        Preconditions.checkNotNull((Object)manifestFile);
        builder.addArgs("--manifest", manifestFile.getAbsolutePath());
        if (config.getResourceDir() != null) {
            try {
                Files.walk(config.getResourceDir().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> builder.addArgs("-R", p.toString()));
            }
            catch (IOException e) {
                throw new AaptException("Failed to walk path " + config.getResourceDir(), new Object[0]);
            }
        }
        builder.addArgs("--auto-add-overlay");
        if (config.getSourceOutputDir() != null) {
            builder.addArgs("--java", config.getSourceOutputDir().getAbsolutePath());
        }
        if (config.getResourceOutputApk() != null) {
            builder.addArgs("-o", config.getResourceOutputApk().getAbsolutePath());
        } else {
            try {
                File tmpOutput = File.createTempFile("aapt-", "-out");
                tmpOutput.deleteOnExit();
                builder.addArgs("-o", tmpOutput.getAbsolutePath());
            }
            catch (IOException e) {
                throw new AaptException("No output apk defined and failed to create tmp file", new Object[]{e});
            }
        }
        if (config.getProguardOutputFile() != null) {
            builder.addArgs("--proguard", config.getProguardOutputFile().getAbsolutePath());
        }
        if (config.getSplits() != null) {
            for (String string : config.getSplits()) {
            }
        }
        if (config.isDebuggable()) {
            // empty if block
        }
        ILogger logger = config.getLogger();
        Preconditions.checkNotNull((Object)logger);
        if (config.getVariantType() != VariantType.ANDROID_TEST && config.getCustomPackageForR() != null) {
            builder.addArgs("--custom-package", config.getCustomPackageForR());
        }
        if (config.isPseudoLocalize()) {
            Preconditions.checkState((this.mBuildToolInfo.getRevision().getMajor() >= 21 ? 1 : 0) != 0);
        }
        if (config.getVariantType() == VariantType.LIBRARY) {
            builder.addArgs("--static-lib");
        }
        AaptOptions options = config.getOptions();
        Preconditions.checkNotNull((Object)options);
        String ignoreAssets = options.getIgnoreAssets();
        if (ignoreAssets != null) {
            // empty if block
        }
        if (config.getOptions().getFailOnMissingConfigEntry()) {
            Preconditions.checkState((this.mBuildToolInfo.getRevision().getMajor() > 20 ? 1 : 0) != 0);
        }
        if ((noCompressList = config.getOptions().getNoCompress()) != null) {
            for (String noCompress : noCompressList) {
                builder.addArgs("-0", noCompress);
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addArgs(additionalParameters);
        }
        ArrayList<String> resourceConfigs = new ArrayList<String>();
        resourceConfigs.addAll(config.getResourceConfigs());
        String preferredDensity = null;
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        preferredDensity = config.getPreferredDensity();
        if (preferredDensity != null && !densityResourceConfigs.isEmpty()) {
            throw new AaptException(String.format("When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)), new Object[0]);
        }
        if (densityResourceConfigs.size() > 1) {
            throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.", new Object[0]);
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.addArgs("-c", joiner.join((Iterable)otherResourceConfigs));
        }
        if (preferredDensity != null) {
            builder.addArgs("--preferred-density", preferredDensity);
        }
        if (config.getSymbolOutputDir() == null || config.getVariantType() == VariantType.LIBRARY || !config.getLibraries().isEmpty()) {
            // empty if block
        }
        builder.addArgs("--no-version-vectors");
        return builder;
    }

    private String getAapt2ExecutablePath() {
        String aapt2 = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.AAPT2);
        if (aapt2 == null || !new File(aapt2).isFile()) {
            throw new IllegalStateException("aapt2 is missing on '" + aapt2 + "'");
        }
        return aapt2;
    }
}

