/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudresourcemanager;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequest;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequestInitializer;
import com.google.api.services.cloudresourcemanager.model.Empty;
import com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.ListOrganizationsResponse;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Organization;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse;
import com.google.api.services.cloudresourcemanager.model.UndeleteProjectRequest;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudResourceManager
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudresourcemanager.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://cloudresourcemanager.googleapis.com/";

    public CloudResourceManager(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    CloudResourceManager(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.21.0 of the Google Cloud Resource Manager API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://cloudresourcemanager.googleapis.com/", CloudResourceManager.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public CloudResourceManager build() {
            return new CloudResourceManager(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setCloudResourceManagerRequestInitializer(CloudResourceManagerRequestInitializer cloudResourceManagerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudResourceManagerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Create create(Project project) throws IOException {
            Create create = new Create(project);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
            return getIamPolicy;
        }

        public List list() throws IOException {
            List list = new List();
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
            return setIamPolicy;
        }

        public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
            return testIamPermissions;
        }

        public Undelete undelete(String string, UndeleteProjectRequest undeleteProjectRequest) throws IOException {
            Undelete undelete = new Undelete(string, undeleteProjectRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)undelete);
            return undelete;
        }

        public Update update(String string, Project project) throws IOException {
            Update update = new Update(string, project);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}";
            @Key
            private String projectId;

            protected Update(String string, Project project) {
                super(CloudResourceManager.this, "PUT", REST_PATH, (Object)project, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Update set$Xgafv(String string) {
                return (Update)super.set$Xgafv(string);
            }

            public Update setAccessToken(String string) {
                return (Update)super.setAccessToken(string);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setBearerToken(String string) {
                return (Update)super.setBearerToken(string);
            }

            public Update setCallback(String string) {
                return (Update)super.setCallback(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPp(Boolean bl) {
                return (Update)super.setPp(bl);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUploadType(String string) {
                return (Update)super.setUploadType(string);
            }

            public Update setUploadProtocol(String string) {
                return (Update)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Undelete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}:undelete";
            @Key
            private String projectId;

            protected Undelete(String string, UndeleteProjectRequest undeleteProjectRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)undeleteProjectRequest, Empty.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Undelete set$Xgafv(String string) {
                return (Undelete)super.set$Xgafv(string);
            }

            public Undelete setAccessToken(String string) {
                return (Undelete)super.setAccessToken(string);
            }

            public Undelete setAlt(String string) {
                return (Undelete)super.setAlt(string);
            }

            public Undelete setBearerToken(String string) {
                return (Undelete)super.setBearerToken(string);
            }

            public Undelete setCallback(String string) {
                return (Undelete)super.setCallback(string);
            }

            public Undelete setFields(String string) {
                return (Undelete)super.setFields(string);
            }

            public Undelete setKey(String string) {
                return (Undelete)super.setKey(string);
            }

            public Undelete setOauthToken(String string) {
                return (Undelete)super.setOauthToken(string);
            }

            public Undelete setPp(Boolean bl) {
                return (Undelete)super.setPp(bl);
            }

            public Undelete setPrettyPrint(Boolean bl) {
                return (Undelete)super.setPrettyPrint(bl);
            }

            public Undelete setQuotaUser(String string) {
                return (Undelete)super.setQuotaUser(string);
            }

            public Undelete setUploadType(String string) {
                return (Undelete)super.setUploadType(string);
            }

            public Undelete setUploadProtocol(String string) {
                return (Undelete)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Undelete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Undelete set(String string, Object object) {
                return (Undelete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends CloudResourceManagerRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1beta1/projects/{resource}:testIamPermissions";
            @Key
            private String resource;

            protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public TestIamPermissions set$Xgafv(String string) {
                return (TestIamPermissions)super.set$Xgafv(string);
            }

            public TestIamPermissions setAccessToken(String string) {
                return (TestIamPermissions)super.setAccessToken(string);
            }

            public TestIamPermissions setAlt(String string) {
                return (TestIamPermissions)super.setAlt(string);
            }

            public TestIamPermissions setBearerToken(String string) {
                return (TestIamPermissions)super.setBearerToken(string);
            }

            public TestIamPermissions setCallback(String string) {
                return (TestIamPermissions)super.setCallback(string);
            }

            public TestIamPermissions setFields(String string) {
                return (TestIamPermissions)super.setFields(string);
            }

            public TestIamPermissions setKey(String string) {
                return (TestIamPermissions)super.setKey(string);
            }

            public TestIamPermissions setOauthToken(String string) {
                return (TestIamPermissions)super.setOauthToken(string);
            }

            public TestIamPermissions setPp(Boolean bl) {
                return (TestIamPermissions)super.setPp(bl);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string) {
                return (TestIamPermissions)super.setQuotaUser(string);
            }

            public TestIamPermissions setUploadType(String string) {
                return (TestIamPermissions)super.setUploadType(string);
            }

            public TestIamPermissions setUploadProtocol(String string) {
                return (TestIamPermissions)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public TestIamPermissions set(String string, Object object) {
                return (TestIamPermissions)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1beta1/projects/{resource}:setIamPolicy";
            @Key
            private String resource;

            protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public SetIamPolicy set$Xgafv(String string) {
                return (SetIamPolicy)super.set$Xgafv(string);
            }

            public SetIamPolicy setAccessToken(String string) {
                return (SetIamPolicy)super.setAccessToken(string);
            }

            public SetIamPolicy setAlt(String string) {
                return (SetIamPolicy)super.setAlt(string);
            }

            public SetIamPolicy setBearerToken(String string) {
                return (SetIamPolicy)super.setBearerToken(string);
            }

            public SetIamPolicy setCallback(String string) {
                return (SetIamPolicy)super.setCallback(string);
            }

            public SetIamPolicy setFields(String string) {
                return (SetIamPolicy)super.setFields(string);
            }

            public SetIamPolicy setKey(String string) {
                return (SetIamPolicy)super.setKey(string);
            }

            public SetIamPolicy setOauthToken(String string) {
                return (SetIamPolicy)super.setOauthToken(string);
            }

            public SetIamPolicy setPp(Boolean bl) {
                return (SetIamPolicy)super.setPp(bl);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string) {
                return (SetIamPolicy)super.setQuotaUser(string);
            }

            public SetIamPolicy setUploadType(String string) {
                return (SetIamPolicy)super.setUploadType(string);
            }

            public SetIamPolicy setUploadProtocol(String string) {
                return (SetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public SetIamPolicy set(String string, Object object) {
                return (SetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CloudResourceManagerRequest<ListProjectsResponse> {
            private static final String REST_PATH = "v1beta1/projects";
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;
            @Key
            private String filter;

            protected List() {
                super(CloudResourceManager.this, "GET", REST_PATH, null, ListProjectsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1beta1/projects/{resource}:getIamPolicy";
            @Key
            private String resource;

            protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public GetIamPolicy set$Xgafv(String string) {
                return (GetIamPolicy)super.set$Xgafv(string);
            }

            public GetIamPolicy setAccessToken(String string) {
                return (GetIamPolicy)super.setAccessToken(string);
            }

            public GetIamPolicy setAlt(String string) {
                return (GetIamPolicy)super.setAlt(string);
            }

            public GetIamPolicy setBearerToken(String string) {
                return (GetIamPolicy)super.setBearerToken(string);
            }

            public GetIamPolicy setCallback(String string) {
                return (GetIamPolicy)super.setCallback(string);
            }

            public GetIamPolicy setFields(String string) {
                return (GetIamPolicy)super.setFields(string);
            }

            public GetIamPolicy setKey(String string) {
                return (GetIamPolicy)super.setKey(string);
            }

            public GetIamPolicy setOauthToken(String string) {
                return (GetIamPolicy)super.setOauthToken(string);
            }

            public GetIamPolicy setPp(Boolean bl) {
                return (GetIamPolicy)super.setPp(bl);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string) {
                return (GetIamPolicy)super.setQuotaUser(string);
            }

            public GetIamPolicy setUploadType(String string) {
                return (GetIamPolicy)super.setUploadType(string);
            }

            public GetIamPolicy setUploadProtocol(String string) {
                return (GetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public GetIamPolicy set(String string, Object object) {
                return (GetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}";
            @Key
            private String projectId;

            protected Get(String string) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}";
            @Key
            private String projectId;

            protected Delete(String string) {
                super(CloudResourceManager.this, "DELETE", REST_PATH, null, Empty.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1beta1/projects";

            protected Create(Project project) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)project, Project.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Organizations {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
            return getIamPolicy;
        }

        public List list() throws IOException {
            List list = new List();
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
            return setIamPolicy;
        }

        public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
            return testIamPermissions;
        }

        public Update update(String string, Organization organization) throws IOException {
            Update update = new Update(string, organization);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends CloudResourceManagerRequest<Organization> {
            private static final String REST_PATH = "v1beta1/organizations/{organizationId}";
            @Key
            private String organizationId;

            protected Update(String string, Organization organization) {
                super(CloudResourceManager.this, "PUT", REST_PATH, (Object)organization, Organization.class);
                this.organizationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter organizationId must be specified.");
            }

            public Update set$Xgafv(String string) {
                return (Update)super.set$Xgafv(string);
            }

            public Update setAccessToken(String string) {
                return (Update)super.setAccessToken(string);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setBearerToken(String string) {
                return (Update)super.setBearerToken(string);
            }

            public Update setCallback(String string) {
                return (Update)super.setCallback(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPp(Boolean bl) {
                return (Update)super.setPp(bl);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUploadType(String string) {
                return (Update)super.setUploadType(string);
            }

            public Update setUploadProtocol(String string) {
                return (Update)super.setUploadProtocol(string);
            }

            public String getOrganizationId() {
                return this.organizationId;
            }

            public Update setOrganizationId(String string) {
                this.organizationId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends CloudResourceManagerRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1beta1/organizations/{resource}:testIamPermissions";
            @Key
            private String resource;

            protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public TestIamPermissions set$Xgafv(String string) {
                return (TestIamPermissions)super.set$Xgafv(string);
            }

            public TestIamPermissions setAccessToken(String string) {
                return (TestIamPermissions)super.setAccessToken(string);
            }

            public TestIamPermissions setAlt(String string) {
                return (TestIamPermissions)super.setAlt(string);
            }

            public TestIamPermissions setBearerToken(String string) {
                return (TestIamPermissions)super.setBearerToken(string);
            }

            public TestIamPermissions setCallback(String string) {
                return (TestIamPermissions)super.setCallback(string);
            }

            public TestIamPermissions setFields(String string) {
                return (TestIamPermissions)super.setFields(string);
            }

            public TestIamPermissions setKey(String string) {
                return (TestIamPermissions)super.setKey(string);
            }

            public TestIamPermissions setOauthToken(String string) {
                return (TestIamPermissions)super.setOauthToken(string);
            }

            public TestIamPermissions setPp(Boolean bl) {
                return (TestIamPermissions)super.setPp(bl);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string) {
                return (TestIamPermissions)super.setQuotaUser(string);
            }

            public TestIamPermissions setUploadType(String string) {
                return (TestIamPermissions)super.setUploadType(string);
            }

            public TestIamPermissions setUploadProtocol(String string) {
                return (TestIamPermissions)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public TestIamPermissions set(String string, Object object) {
                return (TestIamPermissions)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1beta1/organizations/{resource}:setIamPolicy";
            @Key
            private String resource;

            protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public SetIamPolicy set$Xgafv(String string) {
                return (SetIamPolicy)super.set$Xgafv(string);
            }

            public SetIamPolicy setAccessToken(String string) {
                return (SetIamPolicy)super.setAccessToken(string);
            }

            public SetIamPolicy setAlt(String string) {
                return (SetIamPolicy)super.setAlt(string);
            }

            public SetIamPolicy setBearerToken(String string) {
                return (SetIamPolicy)super.setBearerToken(string);
            }

            public SetIamPolicy setCallback(String string) {
                return (SetIamPolicy)super.setCallback(string);
            }

            public SetIamPolicy setFields(String string) {
                return (SetIamPolicy)super.setFields(string);
            }

            public SetIamPolicy setKey(String string) {
                return (SetIamPolicy)super.setKey(string);
            }

            public SetIamPolicy setOauthToken(String string) {
                return (SetIamPolicy)super.setOauthToken(string);
            }

            public SetIamPolicy setPp(Boolean bl) {
                return (SetIamPolicy)super.setPp(bl);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string) {
                return (SetIamPolicy)super.setQuotaUser(string);
            }

            public SetIamPolicy setUploadType(String string) {
                return (SetIamPolicy)super.setUploadType(string);
            }

            public SetIamPolicy setUploadProtocol(String string) {
                return (SetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public SetIamPolicy set(String string, Object object) {
                return (SetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CloudResourceManagerRequest<ListOrganizationsResponse> {
            private static final String REST_PATH = "v1beta1/organizations";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String filter;

            protected List() {
                super(CloudResourceManager.this, "GET", REST_PATH, null, ListOrganizationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1beta1/organizations/{resource}:getIamPolicy";
            @Key
            private String resource;

            protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public GetIamPolicy set$Xgafv(String string) {
                return (GetIamPolicy)super.set$Xgafv(string);
            }

            public GetIamPolicy setAccessToken(String string) {
                return (GetIamPolicy)super.setAccessToken(string);
            }

            public GetIamPolicy setAlt(String string) {
                return (GetIamPolicy)super.setAlt(string);
            }

            public GetIamPolicy setBearerToken(String string) {
                return (GetIamPolicy)super.setBearerToken(string);
            }

            public GetIamPolicy setCallback(String string) {
                return (GetIamPolicy)super.setCallback(string);
            }

            public GetIamPolicy setFields(String string) {
                return (GetIamPolicy)super.setFields(string);
            }

            public GetIamPolicy setKey(String string) {
                return (GetIamPolicy)super.setKey(string);
            }

            public GetIamPolicy setOauthToken(String string) {
                return (GetIamPolicy)super.setOauthToken(string);
            }

            public GetIamPolicy setPp(Boolean bl) {
                return (GetIamPolicy)super.setPp(bl);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string) {
                return (GetIamPolicy)super.setQuotaUser(string);
            }

            public GetIamPolicy setUploadType(String string) {
                return (GetIamPolicy)super.setUploadType(string);
            }

            public GetIamPolicy setUploadProtocol(String string) {
                return (GetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public GetIamPolicy set(String string, Object object) {
                return (GetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CloudResourceManagerRequest<Organization> {
            private static final String REST_PATH = "v1beta1/organizations/{organizationId}";
            @Key
            private String organizationId;

            protected Get(String string) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Organization.class);
                this.organizationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter organizationId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getOrganizationId() {
                return this.organizationId;
            }

            public Get setOrganizationId(String string) {
                this.organizationId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

