/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.builder;

import com.android.tools.idea.jps.AndroidGradleJps;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;

public class AndroidGradleBuildTarget
extends BuildTarget<RootDescriptor> {
    @NonNls
    private static final String BUILD_TARGET_NAME = "Android Gradle Build Target";
    @NotNull
    private final JpsProject myProject;

    protected AndroidGradleBuildTarget(@NotNull JpsProject project) {
        super((BuildTargetType)TargetType.INSTANCE);
        this.myProject = project;
    }

    @NotNull
    public JpsProject getProject() {
        return this.myProject;
    }

    public String getId() {
        return "android_gradle_build_target";
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        return Collections.emptyList();
    }

    @NotNull
    public List<RootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        return Collections.emptyList();
    }

    @Nullable
    public RootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (RootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        return BUILD_TARGET_NAME;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AndroidGradleBuildTarget that = (AndroidGradleBuildTarget)((Object)o);
        return this.myProject.equals(that.myProject);
    }

    public int hashCode() {
        return this.myProject.hashCode();
    }

    public static class RootDescriptor
    extends BuildRootDescriptorImpl {
        RootDescriptor(BuildTarget target, File root) {
            super(target, root);
        }
    }

    public static class TargetType
    extends BuildTargetType<AndroidGradleBuildTarget> {
        public static final TargetType INSTANCE = new TargetType();

        private TargetType() {
            super("android_gradle_build_target_type");
        }

        @NotNull
        public List<AndroidGradleBuildTarget> computeAllTargets(@NotNull JpsModel model) {
            JpsProject project = model.getProject();
            if (!AndroidGradleJps.hasAndroidGradleFacet(project)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new AndroidGradleBuildTarget(project));
        }

        @NotNull
        public BuildTargetLoader<AndroidGradleBuildTarget> createLoader(@NotNull JpsModel model) {
            final JpsProject project = model.getProject();
            return new BuildTargetLoader<AndroidGradleBuildTarget>(){

                @Nullable
                public AndroidGradleBuildTarget createTarget(@NotNull String targetId) {
                    return "android_gradle_build_target".equals(targetId) && AndroidGradleJps.hasAndroidGradleFacet(project) ? new AndroidGradleBuildTarget(project) : null;
                }
            };
        }
    }
}

