/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

class RejectedPromise<T>
extends Promise<T> {
    private final Throwable error;

    public RejectedPromise(@NotNull Throwable error) {
        this.error = error;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> fulfilled) {
        fulfilled.setError(this.error);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected) {
        if (!AsyncPromise.isObsolete(rejected)) {
            rejected.consume((Object)this.error);
        }
        return this;
    }

    @Override
    public RejectedPromise<T> processed(@NotNull Consumer<? super T> processed) {
        processed.consume(null);
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done) {
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull AsyncFunction<? super T, SUB_RESULT> done) {
        return this;
    }

    @Override
    @NotNull
    public Promise.State getState() {
        return Promise.State.REJECTED;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        child.setError(this.error);
    }
}

