/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XLineBreakpointType<P extends XBreakpointProperties>
extends XBreakpointType<XLineBreakpoint<P>, P> {
    protected XLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        super(id, title);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        return false;
    }

    @Nullable
    public abstract P createBreakpointProperties(@NotNull VirtualFile var1, int var2);

    @Override
    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        return XLineBreakpointType.fileLineDisplayText(breakpoint.getPresentableFilePath(), breakpoint.getLine());
    }

    private static String fileLineDisplayText(String path2, int line) {
        return XDebuggerBundle.message("xbreakpoint.default.display.text", line + 1, path2);
    }

    @Override
    public final XSourcePosition getSourcePosition(@NotNull XBreakpoint<P> breakpoint) {
        return null;
    }

    @Override
    public String getShortText(XLineBreakpoint<P> breakpoint) {
        return XLineBreakpointType.fileLineDisplayText(breakpoint.getShortFilePath(), breakpoint.getLine());
    }

    @Override
    public final XLineBreakpoint<P> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<P> creator) {
        return null;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<P> breakpoint, @Nullable XDebugSession currentSession) {
        return Collections.emptyList();
    }

    public Icon getTemporaryIcon() {
        return AllIcons.Debugger.Db_temporary_breakpoint;
    }

    public int getPriority() {
        return 0;
    }

    public boolean canBeHitInOtherPlaces() {
        return false;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<P> breakpoint) {
        return null;
    }

    @NotNull
    public List<? extends XLineBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        return Collections.emptyList();
    }

    public class XLinePsiElementBreakpointVariant
    extends XLineBreakpointAllVariant {
        private final PsiElement myElement;

        public XLinePsiElementBreakpointVariant(XSourcePosition position, PsiElement element) {
            super(position);
            this.myElement = element;
        }

        @Override
        public Icon getIcon() {
            return this.myElement.getIcon(0);
        }

        @Override
        public String getText() {
            return StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0);
        }

        @Override
        public TextRange getHighlightRange() {
            return this.myElement.getTextRange();
        }
    }

    public class XLineBreakpointAllVariant
    extends XLineBreakpointVariant {
        protected final XSourcePosition mySourcePosition;

        public XLineBreakpointAllVariant(XSourcePosition position) {
            this.mySourcePosition = position;
        }

        @Override
        public String getText() {
            return "All";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Override
        @Nullable
        public TextRange getHighlightRange() {
            return null;
        }

        @Override
        @Nullable
        public P createProperties() {
            return XLineBreakpointType.this.createBreakpointProperties(this.mySourcePosition.getFile(), this.mySourcePosition.getLine());
        }
    }

    public abstract class XLineBreakpointVariant {
        public abstract String getText();

        @Nullable
        public abstract Icon getIcon();

        @Nullable
        public abstract TextRange getHighlightRange();

        @Nullable
        public abstract P createProperties();
    }
}

