/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class XDebugProcess {
    private final XDebugSession mySession;
    private ProcessHandler myProcessHandler;

    protected XDebugProcess(@NotNull XDebugSession session) {
        this.mySession = session;
    }

    public final XDebugSession getSession() {
        return this.mySession;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        return XBreakpointHandler.EMPTY_ARRAY;
    }

    @NotNull
    public abstract XDebuggerEditorsProvider getEditorsProvider();

    public void sessionInitialized() {
    }

    public void startPausing() {
    }

    public abstract void startStepOver();

    public void startForceStepInto() {
        this.startStepInto();
    }

    public abstract void startStepInto();

    public abstract void startStepOut();

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return null;
    }

    public void stop() {
        throw new AbstractMethodError();
    }

    @NotNull
    public Promise stopAsync() {
        this.stop();
        return Promise.DONE;
    }

    public abstract void resume();

    public abstract void runToPosition(@NotNull XSourcePosition var1);

    public boolean checkCanPerformCommands() {
        return true;
    }

    public boolean checkCanInitBreakpoints() {
        return true;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return null;
    }

    @NotNull
    public final ProcessHandler getProcessHandler() {
        if (this.myProcessHandler == null) {
            this.myProcessHandler = this.doGetProcessHandler();
            if (this.myProcessHandler == null) {
                this.myProcessHandler = new DefaultDebugProcessHandler();
            }
        }
        return this.myProcessHandler;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        return TextConsoleBuilderFactory.getInstance().createBuilder(this.getSession().getProject()).getConsole();
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return null;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
    }

    public String getCurrentStateMessage() {
        return this.mySession.isStopped() ? XDebuggerBundle.message("debugger.state.message.disconnected", new Object[0]) : XDebuggerBundle.message("debugger.state.message.connected", new Object[0]);
    }

    @Nullable
    public HyperlinkListener getCurrentStateHyperlinkListener() {
        return null;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){};
    }

    public boolean isValuesCustomSorted() {
        return false;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame == null ? null : frame.getEvaluator();
    }

    public boolean isLibraryFrameFilterSupported() {
        return false;
    }
}

