/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.vcsUtil.VcsRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUtil {
    protected static final char[] ourCharsToBeChopped = new char[]{'/', '\\'};
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.vcsUtil.VcsUtil");
    public static final String MAX_VCS_LOADED_SIZE_KB = "idea.max.vcs.loaded.size.kb";
    private static final int ourMaxLoadedFileSize = VcsUtil.computeLoadedFileSize();
    private static final String ANNO_ASPECT = "show.vcs.annotation.aspect.";

    public static int getMaxVcsLoadedFileSize() {
        return ourMaxLoadedFileSize;
    }

    private static int computeLoadedFileSize() {
        int result = (int)PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
        String userLimitKb = System.getProperty(MAX_VCS_LOADED_SIZE_KB);
        try {
            return userLimitKb != null ? Math.min(Integer.parseInt(userLimitKb) * 1024, result) : result;
        }
        catch (NumberFormatException ignored) {
            return result;
        }
    }

    public static void markFileAsDirty(Project project, VirtualFile file) {
        VcsDirtyScopeManager.getInstance(project).fileDirty(file);
    }

    public static void markFileAsDirty(Project project, FilePath path2) {
        VcsDirtyScopeManager.getInstance(project).fileDirty(path2);
    }

    public static void markFileAsDirty(Project project, String path2) {
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(path2));
        VcsUtil.markFileAsDirty(project, filePath2);
    }

    public static void refreshFiles(Project project, HashSet<FilePath> paths) {
        for (FilePath path2 : paths) {
            VirtualFile vFile = path2.getVirtualFile();
            if (vFile == null) continue;
            if (vFile.isDirectory()) {
                VcsUtil.markFileAsDirty(project, vFile);
                continue;
            }
            vFile.refresh(true, vFile.isDirectory());
        }
    }

    public static boolean isFileUnderVcs(Project project, String file) {
        return VcsUtil.getVcsFor(project, VcsUtil.getFilePath(file)) != null;
    }

    public static boolean isFileUnderVcs(Project project, FilePath file) {
        return VcsUtil.getVcsFor(project, file) != null;
    }

    public static boolean isFileForVcs(@NotNull VirtualFile file, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, file) == host;
    }

    public static boolean isFileForVcs(FilePath path2, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, path2) == host;
    }

    public static boolean isFileForVcs(String path2, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, VcsUtil.getFilePath(path2)) == host;
    }

    @Nullable
    public static AbstractVcs getVcsFor(final @NotNull Project project, final FilePath file) {
        final AbstractVcs[] vcss = new AbstractVcs[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!project.isDisposed()) {
                    ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance(project);
                    vcss[0] = mgr != null ? mgr.getVcsFor(file) : null;
                }
            }
        });
        return vcss[0];
    }

    @Nullable
    public static AbstractVcs getVcsFor(final Project project, final @NotNull VirtualFile file) {
        final AbstractVcs[] vcss = new AbstractVcs[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!project.isDisposed()) {
                    ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance(project);
                    vcss[0] = mgr != null ? mgr.getVcsFor(file) : null;
                }
            }
        });
        return vcss[0];
    }

    @Nullable
    public static VirtualFile getVcsRootFor(final Project project, final FilePath file) {
        final VirtualFile[] roots = new VirtualFile[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!project.isDisposed()) {
                    ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance(project);
                    roots[0] = mgr != null ? mgr.getVcsRootFor(file) : null;
                }
            }
        });
        return roots[0];
    }

    @Nullable
    public static VirtualFile getVcsRootFor(final Project project, final VirtualFile file) {
        final VirtualFile[] roots = new VirtualFile[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!project.isDisposed()) {
                    ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance(project);
                    roots[0] = mgr != null ? mgr.getVcsRootFor(file) : null;
                }
            }
        });
        return roots[0];
    }

    public static void refreshFiles(FilePath[] roots, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VcsUtil.refreshFiles(VcsUtil.collectFilesToRefresh(roots), runnable);
    }

    public static void refreshFiles(File[] roots, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VcsUtil.refreshFiles(VcsUtil.collectFilesToRefresh(roots), runnable);
    }

    private static File[] collectFilesToRefresh(FilePath[] roots) {
        File[] result = new File[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            result[i] = roots[i].getIOFile();
        }
        return result;
    }

    private static void refreshFiles(List<VirtualFile> filesToRefresh, Runnable runnable) {
        RefreshQueue.getInstance().refresh(true, true, runnable, filesToRefresh);
    }

    private static List<VirtualFile> collectFilesToRefresh(File[] roots) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (File root : roots) {
            VirtualFile vFile = VcsUtil.findFileFor(root);
            if (vFile != null) {
                result.add(vFile);
                continue;
            }
            LOG.info("Failed to find VirtualFile for one of refresh roots: " + root.getAbsolutePath());
        }
        return result;
    }

    @Nullable
    private static VirtualFile findFileFor(File root) {
        for (File current = root; current != null; current = current.getParentFile()) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(root);
            if (vFile == null) continue;
            return vFile;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getVirtualFile(final String path2) {
        return ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

            @Nullable
            public VirtualFile compute() {
                return LocalFileSystem.getInstance().findFileByPath(path2.replace(File.separatorChar, '/'));
            }
        });
    }

    @Nullable
    public static VirtualFile getVirtualFile(final File file) {
        return ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

            @Nullable
            public VirtualFile compute() {
                return LocalFileSystem.getInstance().findFileByIoFile(file);
            }
        });
    }

    @Nullable
    public static VirtualFile getVirtualFileWithRefresh(File file) {
        if (file == null) {
            return null;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile result = lfs.findFileByIoFile(file);
        if (result == null) {
            result = lfs.refreshAndFindFileByIoFile(file);
        }
        return result;
    }

    public static String getFileContent(final String path2) {
        return ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            public String compute() {
                VirtualFile vFile = VcsUtil.getVirtualFile(path2);
                assert (vFile != null);
                return FileDocumentManager.getInstance().getDocument(vFile).getText();
            }
        });
    }

    @Nullable
    public static byte[] getFileByteContent(@NotNull File file) {
        try {
            return FileUtil.loadFileBytes((File)file);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static FilePath getFilePath(String path2) {
        return VcsUtil.getFilePath(new File(path2));
    }

    public static FilePath getFilePath(@NotNull VirtualFile file) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
    }

    public static FilePath getFilePath(@NotNull File file) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
    }

    public static FilePath getFilePath(@NotNull String path2, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePath(path2, isDirectory);
    }

    public static FilePath getFilePathOnNonLocal(String path2, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOnNonLocal(path2, isDirectory);
    }

    public static FilePath getFilePath(@NotNull File file, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file, isDirectory);
    }

    public static FilePath getFilePathForDeletedFile(@NotNull String path2, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOnDeleted(new File(path2), isDirectory);
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull String name) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(parent, name);
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull String fileName, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePath(parent, fileName, isDirectory);
    }

    public static void showStatusMessage(final Project project, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isOpen()) {
                    StatusBar.Info.set(message, project);
                }
            }
        });
    }

    public static boolean isRenameChange(Change change) {
        boolean isRenamed = false;
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        if (before != null && after != null) {
            String newFile;
            String prevFile = VcsUtil.getCanonicalLocalPath(before.getFile().getPath());
            isRenamed = !prevFile.equals(newFile = VcsUtil.getCanonicalLocalPath(after.getFile().getPath()));
        }
        return isRenamed;
    }

    public static boolean isChangeForNew(Change change) {
        return change.getBeforeRevision() == null && change.getAfterRevision() != null;
    }

    public static boolean isChangeForDeleted(Change change) {
        return change.getBeforeRevision() != null && change.getAfterRevision() == null;
    }

    public static boolean isChangeForFolder(Change change) {
        ContentRevision revB = change.getBeforeRevision();
        ContentRevision revA = change.getAfterRevision();
        return revA != null && revA.getFile().isDirectory() || revB != null && revB.getFile().isDirectory();
    }

    public static FilePath[] sortPathsFromInnermost(FilePath[] files) {
        return VcsUtil.sortPaths(files, -1);
    }

    public static FilePath[] sortPathsFromOutermost(FilePath[] files) {
        return VcsUtil.sortPaths(files, 1);
    }

    private static FilePath[] sortPaths(FilePath[] files, final int sign) {
        Arrays.sort(files, new Comparator<FilePath>(){

            @Override
            public int compare(@NotNull FilePath o1, @NotNull FilePath o2) {
                return sign * o1.getPath().compareTo(o2.getPath());
            }
        });
        return files;
    }

    @Nullable
    public static VirtualFile getOneVirtualFile(AnActionEvent e) {
        VirtualFile[] files = VcsUtil.getVirtualFiles(e);
        return files.length != 1 ? null : files[0];
    }

    public static VirtualFile[] getVirtualFiles(AnActionEvent e) {
        VirtualFile[] files = e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return files == null ? VirtualFile.EMPTY_ARRAY : files;
    }

    public static void collectFiles(final VirtualFile dir, final List<VirtualFile> files, final boolean recursive, final boolean addDirectories) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(VcsBundle.message("exception.text.file.should.be.directory", dir.getPresentableUrl()));
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively(dir, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file.isDirectory()) {
                    if (addDirectories) {
                        files.add(file);
                    }
                    if (!recursive && !Comparing.equal((Object)file, (Object)dir)) {
                        return false;
                    }
                } else if (fileTypeManager == null || file.getFileType() != FileTypes.UNKNOWN) {
                    files.add(file);
                }
                return true;
            }
        });
    }

    public static boolean runVcsProcessWithProgress(final VcsRunnable runnable, String progressTitle, boolean canBeCanceled, Project project) throws VcsException {
        final Ref ex = new Ref();
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (VcsException e) {
                    ex.set((Object)e);
                }
            }
        }, progressTitle, canBeCanceled, project);
        if (!ex.isNull()) {
            throw (VcsException)ex.get();
        }
        return result;
    }

    public static VirtualFile waitForTheFile(final String path2) {
        final VirtualFile[] file = new VirtualFile[1];
        final Application app = ApplicationManager.getApplication();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                app.runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        file[0] = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
                    }
                });
            }
        };
        app.invokeAndWait(action, ModalityState.defaultModalityState());
        return file[0];
    }

    public static String getCanonicalLocalPath(String localPath) {
        if ((localPath = VcsUtil.chopTrailingChars(localPath.trim().replace('\\', '/'), ourCharsToBeChopped)).length() == 2 && localPath.charAt(1) == ':') {
            localPath = localPath + '/';
        }
        return localPath;
    }

    public static String getCanonicalPath(String path2) {
        String canonPath;
        try {
            canonPath = new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = path2;
        }
        return canonPath;
    }

    public static String getCanonicalPath(File file) {
        String canonPath;
        try {
            canonPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = file.getAbsolutePath();
        }
        return canonPath;
    }

    public static String chopTrailingChars(String source, char[] chars) {
        boolean atLeastOneCharWasChopped;
        StringBuilder sb = new StringBuilder(source);
        do {
            atLeastOneCharWasChopped = false;
            for (int i = 0; i < chars.length && sb.length() > 0; ++i) {
                if (sb.charAt(sb.length() - 1) != chars[i]) continue;
                sb.deleteCharAt(sb.length() - 1);
                atLeastOneCharWasChopped = true;
            }
        } while (atLeastOneCharWasChopped);
        return sb.toString();
    }

    public static VirtualFile[] paths2VFiles(String[] paths) {
        VirtualFile[] files = new VirtualFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = VcsUtil.getVirtualFile(paths[i]);
        }
        return files;
    }

    public static boolean isAspectAvailableByDefault(String id) {
        return VcsUtil.isAspectAvailableByDefault(id, true);
    }

    public static boolean isAspectAvailableByDefault(@Nullable String id, boolean defaultValue) {
        if (id == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(ANNO_ASPECT + id, defaultValue);
    }

    public static void setAspectAvailability(String aspectID, boolean showByDefault) {
        PropertiesComponent.getInstance().setValue(ANNO_ASPECT + aspectID, String.valueOf(showByDefault));
    }

    public static boolean isPathRemote(String path2) {
        int idx = path2.indexOf("://");
        if (idx == -1) {
            int idx2 = path2.indexOf(":\\\\");
            if (idx2 == -1) {
                return false;
            }
            return idx2 > 0;
        }
        return idx > 0;
    }

    public static String getPathForProgressPresentation(@NotNull File file) {
        return file.getName() + " (" + file.getParent() + ")";
    }

    @NotNull
    public static Collection<VcsDirectoryMapping> findRoots(@NotNull VirtualFile rootDir, @NotNull Project project) throws IllegalArgumentException {
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("Can't find VCS at the target file system path. Reason: expected to find a directory there but it's not. The path: " + rootDir.getParent());
        }
        Collection<VcsRoot> roots = ServiceManager.getService(project, VcsRootDetector.class).detect(rootDir);
        ArrayList result = ContainerUtilRt.newArrayList();
        for (VcsRoot vcsRoot : roots) {
            VirtualFile vFile = vcsRoot.getPath();
            AbstractVcs rootVcs = vcsRoot.getVcs();
            if (rootVcs == null || vFile == null) continue;
            result.add(new VcsDirectoryMapping(vFile.getPath(), rootVcs.getName()));
        }
        return result;
    }

    @NotNull
    public static List<VcsDirectoryMapping> addMapping(@NotNull List<VcsDirectoryMapping> existingMappings, @NotNull String path2, @NotNull String vcs) {
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(existingMappings);
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            VcsDirectoryMapping mapping = (VcsDirectoryMapping)iterator.next();
            if (mapping.isDefaultMapping() && StringUtil.isEmptyOrSpaces((String)mapping.getVcs())) {
                LOG.debug("Removing <Project> -> <None> mapping");
                iterator.remove();
                continue;
            }
            if (!FileUtil.pathsEqual((String)mapping.getDirectory(), (String)path2)) continue;
            if (!StringUtil.isEmptyOrSpaces((String)mapping.getVcs())) {
                LOG.warn("Substituting existing mapping [" + path2 + "] -> [" + mapping.getVcs() + "] with [" + vcs + "]");
            } else {
                LOG.debug("Removing [" + path2 + "] -> <None> mapping");
            }
            iterator.remove();
        }
        mappings.add(new VcsDirectoryMapping(path2, vcs));
        return mappings;
    }
}

