/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui.actions.generate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenerateDomElementProvider<T extends DomElement> {
    private final String myDescription;

    public GenerateDomElementProvider(String description) {
        this.myDescription = description;
    }

    public boolean isAvailableForElement(@NotNull DomElement contextElement) {
        return true;
    }

    @Nullable
    public abstract T generate(Project var1, Editor var2, PsiFile var3);

    public void navigate(DomElement element) {
        if (element != null && element.isValid()) {
            Object copy = element.createStableCopy();
            final Project project = element.getManager().getProject();
            final DomElementNavigationProvider navigateProvider = GenerateDomElementProvider.getNavigationProviderName(project);
            if (navigateProvider != null && navigateProvider.canNavigate((DomElement)copy)) {
                ApplicationManager.getApplication().invokeLater(new Runnable((DomElement)copy){
                    final /* synthetic */ DomElement val$copy;
                    {
                        this.val$copy = domElement;
                    }

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            GenerateDomElementProvider.this.doNavigate(navigateProvider, this.val$copy);
                        }
                    }
                });
            }
        }
    }

    protected void doNavigate(DomElementNavigationProvider navigateProvider, DomElement copy) {
        navigateProvider.navigate(copy, true);
    }

    protected static DomElementNavigationProvider getNavigationProviderName(Project project) {
        return DomElementsNavigationManager.getManager(project).getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME);
    }

    public String getDescription() {
        return this.myDescription == null ? "" : this.myDescription;
    }
}

