/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomJavaUtil {
    private DomJavaUtil() {
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull PsiFile file, @Nullable Module module, @Nullable GlobalSearchScope searchScope) {
        return DomJavaUtil.findClass(name, file, module, searchScope, false);
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull PsiFile file, @Nullable Module module, @Nullable GlobalSearchScope searchScope, boolean searchAnonymous) {
        PsiClass aClass;
        if (name == null) {
            return null;
        }
        GlobalSearchScope globalSearchScope = searchScope = searchScope != null ? searchScope : DomJavaUtil.calcScope(file, module);
        if (searchAnonymous) {
            aClass = ClassUtil.findPsiClass(file.getManager(), name, null, false, searchScope);
        } else {
            String fqn = name.indexOf(36) >= 0 ? name.replace('$', '.') : name;
            aClass = JavaPsiFacade.getInstance(file.getProject()).findClass(fqn, searchScope);
        }
        if (aClass != null) assert (aClass.isValid()) : name;
        return aClass;
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull DomElement element) {
        return DomJavaUtil.findClass(name, element, false);
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull DomElement element, boolean searchAnonymous) {
        assert (element.isValid());
        if (DomUtil.hasXml(element)) {
            return DomJavaUtil.findClass(name, DomUtil.getFile(element), element.getModule(), element.getResolveScope(), searchAnonymous);
        }
        return null;
    }

    @NotNull
    private static GlobalSearchScope calcScope(@NotNull PsiFile file, @Nullable Module module) {
        if (module == null) {
            return file.getResolveScope();
        }
        VirtualFile virtualFile = (file = file.getOriginalFile()).getVirtualFile();
        if (virtualFile == null) {
            return GlobalSearchScope.moduleRuntimeScope(module, true);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(file.getProject()).getFileIndex();
        return module.getModuleRuntimeScope(fileIndex.isInTestSourceContent(virtualFile));
    }
}

