/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UniqueResultsQuery<T, M>
implements Query<T> {
    private final Query<T> myOriginal;
    private final TObjectHashingStrategy<M> myHashingStrategy;
    private final Function<T, M> myMapper;

    public UniqueResultsQuery(@NotNull Query<T> original) {
        this(original, ContainerUtil.canonicalStrategy(), FunctionUtil.id());
    }

    public UniqueResultsQuery(@NotNull Query<T> original, @NotNull TObjectHashingStrategy<M> hashingStrategy) {
        this(original, hashingStrategy, FunctionUtil.id());
    }

    public UniqueResultsQuery(@NotNull Query<T> original, @NotNull TObjectHashingStrategy<M> hashingStrategy, @NotNull Function<T, M> mapper) {
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = mapper;
    }

    @Override
    public T findFirst() {
        return this.myOriginal.findFirst();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        return this.process(consumer, Collections.synchronizedSet(new THashSet(this.myHashingStrategy)));
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<T> consumer) {
        return this.processAsync(consumer, Collections.synchronizedSet(new THashSet(this.myHashingStrategy)));
    }

    private boolean process(@NotNull Processor<T> consumer, @NotNull Set<M> processedElements) {
        return this.myOriginal.forEach(new MyProcessor(processedElements, consumer));
    }

    @NotNull
    private AsyncFuture<Boolean> processAsync(@NotNull Processor<T> consumer, @NotNull Set<M> processedElements) {
        return this.myOriginal.forEachAsync(new MyProcessor(processedElements, consumer));
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(Collections.synchronizedList(new ArrayList()));
        this.forEach((Processor<T>)processor);
        return processor.getResults();
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }

    public String toString() {
        return "UniqueQuery: " + this.myOriginal;
    }

    private class MyProcessor
    implements Processor<T> {
        private final Set<M> myProcessedElements;
        private final Processor<T> myConsumer;

        public MyProcessor(@NotNull Set<M> processedElements, Processor<T> consumer) {
            this.myProcessedElements = processedElements;
            this.myConsumer = consumer;
        }

        public boolean process(T t) {
            return !this.myProcessedElements.add(UniqueResultsQuery.this.myMapper.fun(t)) || this.myConsumer.process(t);
        }
    }
}

