/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PathsList {
    private final List<String> myPath = new ArrayList<String>();
    private final List<String> myPathTail = new ArrayList<String>();
    private final Set<String> myPathSet = new HashSet();
    private static final Function<String, VirtualFile> PATH_TO_LOCAL_VFILE = new NullableFunction<String, VirtualFile>(){

        public VirtualFile fun(String path2) {
            return StandardFileSystems.local().findFileByPath(path2.replace(File.separatorChar, '/'));
        }
    };
    private static final Function<VirtualFile, String> LOCAL_PATH = new Function<VirtualFile, String>(){

        public String fun(VirtualFile file) {
            return PathUtil.getLocalPath(file);
        }
    };
    private static final Function<String, VirtualFile> PATH_TO_DIR = new NullableFunction<String, VirtualFile>(){

        public VirtualFile fun(String s) {
            FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(s);
            VirtualFile localFile = (VirtualFile)PATH_TO_LOCAL_VFILE.fun((Object)s);
            if (localFile == null) {
                return null;
            }
            if (ArchiveFileType.INSTANCE.equals(fileType) && !localFile.isDirectory()) {
                return StandardFileSystems.getJarRootForLocalFile(localFile);
            }
            return localFile;
        }
    };

    public void add(@NonNls String path2) {
        this.addAllLast(this.chooseFirstTimeItems(path2), this.myPath);
    }

    public void remove(@NotNull String path2) {
        this.myPath.remove(path2);
        this.myPathTail.remove(path2);
        this.myPathSet.remove(path2);
    }

    public void add(VirtualFile file) {
        this.add((String)LOCAL_PATH.fun((Object)file));
    }

    public void addFirst(@NonNls String path2) {
        Iterator<String> elements = this.chooseFirstTimeItems(path2);
        int index = 0;
        while (elements.hasNext()) {
            String element = elements.next();
            this.myPath.add(index, element);
            this.myPathSet.add(element);
            ++index;
        }
    }

    public void addTail(String path2) {
        this.addAllLast(this.chooseFirstTimeItems(path2), this.myPathTail);
    }

    private Iterator<String> chooseFirstTimeItems(String path2) {
        if (path2 == null) {
            return ContainerUtil.emptyIterator();
        }
        final StringTokenizer tokenizer = new StringTokenizer(path2, File.pathSeparator);
        Enumeration<String> en = new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return tokenizer.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)tokenizer.nextElement();
            }
        };
        return FilteringIterator.create((Iterator)ContainerUtil.iterate((Enumeration)en), (Condition)new Condition<String>(){

            public boolean value(String element) {
                return !(element = element.trim()).isEmpty() && !PathsList.this.myPathSet.contains(element);
            }
        });
    }

    private void addAllLast(Iterator<String> elements, List<String> toArray) {
        while (elements.hasNext()) {
            String element = elements.next();
            toArray.add(element);
            this.myPathSet.add(element);
        }
    }

    @NotNull
    public String getPathsString() {
        return StringUtil.join(this.getPathList(), (String)File.pathSeparator);
    }

    public List<String> getPathList() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.myPath);
        result.addAll(this.myPathTail);
        return result;
    }

    public List<VirtualFile> getVirtualFiles() {
        return ContainerUtil.skipNulls((Collection)ContainerUtil.map(this.getPathList(), PATH_TO_LOCAL_VFILE));
    }

    public List<VirtualFile> getRootDirs() {
        return ContainerUtil.skipNulls((Collection)ContainerUtil.map(this.getPathList(), PATH_TO_DIR));
    }

    public void addAll(List<String> allClasspath) {
        for (String path2 : allClasspath) {
            this.add(path2);
        }
    }

    public void addAllFiles(File[] classpathList) {
        this.addAllFiles(Arrays.asList(classpathList));
    }

    public void addAllFiles(List<File> classpathList) {
        for (File file : classpathList) {
            this.add(file);
        }
    }

    public void add(File file) {
        this.add(FileUtil.toCanonicalPath((String)file.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addVirtualFiles(Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            this.add(file);
        }
    }

    public void addVirtualFiles(VirtualFile[] files) {
        for (VirtualFile file : files) {
            this.add(file);
        }
    }
}

