/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageGroupBase;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonCodeUsageGroupingRule
implements UsageGroupingRule {
    private final Project myProject;

    public NonCodeUsageGroupingRule(Project project) {
        this.myProject = project;
    }

    @Override
    public UsageGroup groupUsage(@NotNull Usage usage) {
        VirtualFile file;
        if (usage instanceof UsageInFile && (file = ((UsageInFile)usage).getFile()) != null && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, this.myProject)) {
            return UsageInGeneratedCodeGroup.INSTANCE;
        }
        if (usage instanceof PsiElementUsage) {
            UsageInfo usageInfo;
            if (usage instanceof UsageInfo2UsageAdapter && (usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo()).isDynamicUsage()) {
                return DynamicUsageGroup.INSTANCE;
            }
            if (((PsiElementUsage)usage).isNonCodeUsage()) {
                return NonCodeUsageGroup.INSTANCE;
            }
            return CodeUsageGroup.INSTANCE;
        }
        return null;
    }

    private static class DynamicUsageGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new DynamicUsageGroup();
        @NonNls
        private static final String DYNAMIC_CAPTION = "Dynamic usages";

        public DynamicUsageGroup() {
            super(1);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if (view == null) {
                return DYNAMIC_CAPTION;
            }
            String dynamicCodeUsagesString = view.getPresentation().getDynamicCodeUsagesString();
            return dynamicCodeUsagesString == null ? DYNAMIC_CAPTION : dynamicCodeUsagesString;
        }

        public String toString() {
            return "DynamicUsages";
        }
    }

    private static class NonCodeUsageGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new NonCodeUsageGroup();

        private NonCodeUsageGroup() {
            super(2);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            return view == null ? UsageViewBundle.message("node.non.code.usages", new Object[0]) : view.getPresentation().getNonCodeUsagesString();
        }

        @Override
        public void update() {
        }

        public String toString() {
            return "NonCodeUsages";
        }
    }

    private static class UsageInGeneratedCodeGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new UsageInGeneratedCodeGroup();

        private UsageInGeneratedCodeGroup() {
            super(3);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            return view == null ? UsageViewBundle.message("node.usages.in.generated.code", new Object[0]) : view.getPresentation().getUsagesInGeneratedCodeString();
        }

        public String toString() {
            return "UsagesInGeneratedCode";
        }
    }

    private static class CodeUsageGroup
    extends UsageGroupBase {
        private static final UsageGroup INSTANCE = new CodeUsageGroup();

        private CodeUsageGroup() {
            super(0);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            return view == null ? UsageViewBundle.message("node.group.code.usages", new Object[0]) : view.getPresentation().getCodeUsagesString();
        }

        public String toString() {
            return "CodeUsages";
        }
    }
}

