/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.SearchInBackgroundOption;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.SearchForUsagesRunnable;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewManagerImpl
extends UsageViewManager {
    private final Project myProject;
    private static final Key<UsageView> USAGE_VIEW_KEY = Key.create((String)"USAGE_VIEW");

    public UsageViewManagerImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public UsageView createUsageView(@NotNull UsageTarget[] targets, @NotNull Usage[] usages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> usageSearcherFactory) {
        UsageViewImpl usageView = new UsageViewImpl(this.myProject, presentation, targets, usageSearcherFactory);
        UsageViewManagerImpl.appendUsages(usages, usageView);
        usageView.setSearchInProgress(false);
        return usageView;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> factory) {
        UsageView usageView = this.createUsageView(searchedFor, foundUsages, presentation, factory);
        this.addContent((UsageViewImpl)usageView, presentation);
        this.showToolWindow(true);
        return usageView;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation) {
        return this.showUsages(searchedFor, foundUsages, presentation, null);
    }

    void addContent(@NotNull UsageViewImpl usageView, @NotNull UsageViewPresentation presentation) {
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).addContent(presentation.getTabText(), presentation.getTabName(), presentation.getToolwindowTitle(), true, usageView.getComponent(), presentation.isOpenInNewTab(), true);
        usageView.setContent(content);
        content.putUserData(USAGE_VIEW_KEY, usageView);
    }

    @Override
    public UsageView searchAndShowUsages(@NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, boolean showPanelIfOnlyOneUsage, boolean showNotFoundMessage, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(showNotFoundMessage);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        return this.doSearchAndShow(searchFor, searcherFactory, presentation, processPresentation, listener);
    }

    private UsageView doSearchAndShow(final @NotNull UsageTarget[] searchFor, final @NotNull Factory<UsageSearcher> searcherFactory, final @NotNull UsageViewPresentation presentation, final @NotNull FindUsagesProcessPresentation processPresentation, final @Nullable UsageViewManager.UsageViewStateListener listener) {
        final SearchScope searchScopeToWarnOfFallingOutOf = this.getMaxSearchScopeToWarnOfFallingOutOf(searchFor);
        final AtomicReference usageViewRef = new AtomicReference();
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, UsageViewManagerImpl.getProgressTitle(presentation), true, new SearchInBackgroundOption()){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                new SearchForUsagesRunnable(UsageViewManagerImpl.this, UsageViewManagerImpl.this.myProject, usageViewRef, presentation, searchFor, (Factory<UsageSearcher>)searcherFactory, processPresentation, searchScopeToWarnOfFallingOutOf, listener).run();
            }

            @Override
            @Nullable
            public Task.NotificationInfo getNotificationInfo() {
                String notification = usageViewRef.get() != null ? ((UsageViewImpl)usageViewRef.get()).getUsagesCount() + " Usage(s) Found" : "No Usages Found";
                return new Task.NotificationInfo("Find Usages", "Find Usages Finished", notification);
            }
        };
        ProgressManager.getInstance().run(task);
        return (UsageView)usageViewRef.get();
    }

    @NotNull
    SearchScope getMaxSearchScopeToWarnOfFallingOutOf(@NotNull UsageTarget[] searchFor) {
        UsageTarget target = searchFor[0];
        if (target instanceof TypeSafeDataProvider) {
            final SearchScope[] scope = new SearchScope[1];
            ((TypeSafeDataProvider)((Object)target)).calcData(UsageView.USAGE_SCOPE, new DataSink(){

                @Override
                public <T> void put(DataKey<T> key, T data) {
                    scope[0] = (SearchScope)data;
                }
            });
            return scope[0];
        }
        return GlobalSearchScope.allScope(this.myProject);
    }

    @Override
    public void searchAndShowUsages(@NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        this.doSearchAndShow(searchFor, searcherFactory, presentation, processPresentation, listener);
    }

    @Override
    public UsageView getSelectedUsageView() {
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).getSelectedContent();
        if (content != null) {
            return (UsageView)content.getUserData(USAGE_VIEW_KEY);
        }
        return null;
    }

    @NotNull
    public static String getProgressTitle(@NotNull UsageViewPresentation presentation) {
        String scopeText = presentation.getScopeText();
        String usagesString = StringUtil.capitalize((String)presentation.getUsagesString());
        return UsageViewBundle.message("progress.searching.for.in", usagesString, scopeText, presentation.getContextText());
    }

    void showToolWindow(boolean activateWindow) {
        ToolWindow toolWindow = ToolWindowManager.getInstance(this.myProject).getToolWindow(ToolWindowId.FIND);
        toolWindow.show(null);
        if (activateWindow && !toolWindow.isActive()) {
            toolWindow.activate(null);
        }
    }

    private static void appendUsages(final @NotNull Usage[] foundUsages, final @NotNull UsageViewImpl usageView) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (Usage foundUsage : foundUsages) {
                    usageView.appendUsage(foundUsage);
                }
            }
        });
    }

    public static void showTooManyUsagesWarning(final @NotNull Project project, final @NotNull TooManyUsagesStatus tooManyUsagesStatus, final @NotNull ProgressIndicator indicator, final @NotNull UsageViewPresentation presentation, final int usageCount, final @Nullable UsageViewImpl usageView) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (usageView != null && usageView.searchHasBeenCancelled() || indicator.isCanceled()) {
                    return;
                }
                String message = UsageViewBundle.message("find.excessive.usage.count.prompt", usageCount, StringUtil.pluralize((String)presentation.getUsagesWord()));
                UsageLimitUtil.Result ret = UsageLimitUtil.showTooManyUsagesWarning(project, message, presentation);
                if (ret == UsageLimitUtil.Result.ABORT) {
                    if (usageView != null) {
                        usageView.cancelCurrentSearch();
                    }
                    indicator.cancel();
                }
                tooManyUsagesStatus.userResponded();
            }
        });
    }

    public static long getFileLength(final @NotNull VirtualFile virtualFile) {
        final long[] length = new long[]{-1L};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!virtualFile.isValid()) {
                    return;
                }
                length[0] = virtualFile.getLength();
            }
        });
        return length[0];
    }

    @NotNull
    public static String presentableSize(long bytes) {
        long megabytes = bytes / 0x100000L;
        return UsageViewBundle.message("find.file.size.megabytes", Long.toString(megabytes));
    }

    public static boolean isInScope(@NotNull Usage usage, @NotNull SearchScope searchScope) {
        VirtualFile file;
        VirtualFile virtualFile;
        PsiElement element = null;
        if (usage instanceof UsageInFile) {
            virtualFile = ((UsageInFile)usage).getFile();
        } else if (usage instanceof PsiElementUsage) {
            element = ((PsiElementUsage)usage).getElement();
            virtualFile = PsiUtilCore.getVirtualFile(element);
        } else {
            virtualFile = file = null;
        }
        if (file != null) {
            return UsageViewManagerImpl.isFileInScope(file, searchScope);
        }
        if (element != null) {
            return searchScope instanceof EverythingGlobalScope || searchScope instanceof ProjectScopeImpl || searchScope instanceof ProjectAndLibrariesScope;
        }
        return false;
    }

    private static boolean isFileInScope(@NotNull VirtualFile file, @NotNull SearchScope searchScope) {
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        if (searchScope instanceof LocalSearchScope) {
            return ((LocalSearchScope)searchScope).isInScope(file);
        }
        return ((GlobalSearchScope)searchScope).contains(file);
    }

    @NotNull
    public static String outOfScopeMessage(int nUsages, @NotNull SearchScope searchScope) {
        return (nUsages == 1 ? "One usage is" : nUsages + " usages are") + " out of scope '" + searchScope.getDisplayName() + "'";
    }
}

