/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleEx;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UsageNodeTreeBuilder {
    private final GroupNode myRoot;
    private final Project myProject;
    private final UsageTarget[] myTargets;
    private UsageGroupingRule[] myGroupingRules;
    private UsageFilteringRule[] myFilteringRules;

    UsageNodeTreeBuilder(@NotNull UsageTarget[] targets, @NotNull UsageGroupingRule[] groupingRules, @NotNull UsageFilteringRule[] filteringRules, @NotNull GroupNode root, @NotNull Project project) {
        this.myTargets = targets;
        this.myGroupingRules = groupingRules;
        this.myFilteringRules = filteringRules;
        this.myRoot = root;
        this.myProject = project;
    }

    public void setGroupingRules(@NotNull UsageGroupingRule[] rules) {
        this.myGroupingRules = rules;
    }

    public void setFilteringRules(@NotNull UsageFilteringRule[] rules) {
        this.myFilteringRules = rules;
    }

    public boolean isVisible(@NotNull Usage usage) {
        for (UsageFilteringRule rule : this.myFilteringRules) {
            boolean visible = rule instanceof UsageFilteringRuleEx ? ((UsageFilteringRuleEx)rule).isVisible(usage, this.myTargets) : rule.isVisible(usage);
            if (visible) continue;
            return false;
        }
        return true;
    }

    @Nullable
    UsageNode appendUsage(@NotNull Usage usage, @NotNull Consumer<Runnable> edtQueue) {
        if (!this.isVisible(usage)) {
            return null;
        }
        boolean dumb = DumbService.isDumb(this.myProject);
        GroupNode lastGroupNode = this.myRoot;
        for (int i = 0; i < this.myGroupingRules.length; ++i) {
            UsageGroup group;
            UsageGroupingRule rule = this.myGroupingRules[i];
            if (dumb && !DumbService.isDumbAware(rule) || (group = rule instanceof UsageGroupingRuleEx ? ((UsageGroupingRuleEx)rule).groupUsage(usage, this.myTargets) : rule.groupUsage(usage)) == null) continue;
            lastGroupNode = lastGroupNode.addGroup(group, i, edtQueue);
        }
        return lastGroupNode.addUsage(usage, edtQueue);
    }
}

